<?php
$page_title = "Match Categories";
require_once 'header.php';

// Define the categories. This makes it easy to add more later.
$categories = [
    'br'   => ['name' => 'BR Match', 'image' => '../images/b.jpeg'],
    'cs'   => ['name' => 'Clash Squad', 'image' => '../images/c.jpeg'],
    'lone' => ['name' => 'Lone Wolf', 'image' => '../images/lon.jpeg'],
    'cs2'  => ['name' => 'CS 2 VS 2', 'image' => '../images/c2.jpeg'],
    'ludo' => ['name' => 'Ludo', 'image' => '../images/lud.jpeg'],
    'free' => ['name' => 'Free Match', 'image' => '../images/fre.jpeg']
];

// Fetch the count of upcoming matches for EACH category
$sql = "SELECT category, COUNT(id) as count 
        FROM tournaments 
        WHERE status = 'upcoming' 
        GROUP BY category";
$result = $conn->query($sql);
$match_counts = [];
if ($result) {
    while($row = $result->fetch_assoc()) {
        $match_counts[$row['category']] = $row['count'];
    }
}
$conn->close();
?>
<style>
    .category-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
        gap: 20px;
    }
    .category-card {
        display: block;
        background: var(--card-bg);
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.05);
        text-decoration: none;
        color: #111827;
        overflow: hidden;
        transition: transform 0.2s, box-shadow 0.2s;
    }
    .category-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 15px rgba(0,0,0,0.1);
    }
    .category-card img {
        width: 100%;
        height: 120px;
        object-fit: cover;
    }
    .card-content {
        padding: 15px;
    }
    .card-content h3 {
        margin: 0 0 5px 0;
        font-size: 18px;
    }
    .card-content p {
        margin: 0;
        font-size: 14px;
        color: var(--secondary);
    }
</style>

<div class="category-grid">
    <?php foreach ($categories as $code => $details): ?>
        <a href="match_list_admin.php?category=<?php echo $code; ?>" class="category-card">
            <img src="<?php echo htmlspecialchars($details['image']); ?>" alt="<?php echo htmlspecialchars($details['name']); ?>">
            <div class="card-content">
                <h3><?php echo htmlspecialchars($details['name']); ?></h3>
                <p><?php echo $match_counts[$code] ?? 0; ?> upcoming matches</p>
            </div>
        </a>
    <?php endforeach; ?>
</div>

<?php
require_once 'footer.php';
?>