<?php

// The header file already has the session_start() and security check.
require_once 'header.php';

// --- Fetch Dashboard Statistics ---

// 1. Total Users
$total_users_sql = "SELECT COUNT(id) as count FROM users";
$total_users = $conn->query($total_users_sql)->fetch_assoc()['count'];

// 2. Total Tournaments
$total_tournaments_sql = "SELECT COUNT(id) as count FROM tournaments";
$total_tournaments = $conn->query($total_tournaments_sql)->fetch_assoc()['count'];

// 3. Total Revenue (Sum of all completed deposits)
$total_revenue_sql = "SELECT COALESCE(SUM(amount), 0) as total FROM transactions WHERE type = 'deposit' AND status = 'completed'";
$total_revenue = $conn->query($total_revenue_sql)->fetch_assoc()['total'];

// 4. Pending Deposits
$pending_deposits_sql = "SELECT COUNT(id) as count FROM transactions WHERE type = 'deposit' AND status = 'pending'";
$pending_deposits = $conn->query($pending_deposits_sql)->fetch_assoc()['count'];

// 5. Pending Withdrawals
$pending_withdrawals_sql = "SELECT COUNT(id) as count FROM transactions WHERE type = 'withdrawal' AND status = 'pending'";
$pending_withdrawals = $conn->query($pending_withdrawals_sql)->fetch_assoc()['count'];

$conn->close();
?>
<style>
    .stats-grid {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
        gap: 20px;
    }
    .stat-card {
        background: var(--card-bg);
        padding: 25px;
        border-radius: 12px;
        box-shadow: 0 4px 6px rgba(0,0,0,0.05);
    }
    .stat-card .stat-title {
        font-size: 14px;
        color: var(--secondary);
        font-weight: 500;
        margin-bottom: 10px;
    }
    .stat-card .stat-value {
        font-size: 32px;
        font-weight: 700;
        color: #111827;
    }
    .stat-card.pending {
        background: #FFFBEB;
        color: #B45309;
        border-left: 5px solid #FBBF24;
    }
    .stat-card.pending .stat-value {
        color: #D97706;
    }
</style>

<div class="stats-grid">
    <div class="stat-card">
        <div class="stat-title">Total Users</div>
        <div class="stat-value"><?php echo $total_users; ?></div>
    </div>
    <div class="stat-card">
        <div class="stat-title">Total Tournaments</div>
        <div class="stat-value"><?php echo $total_tournaments; ?></div>
    </div>
    <div class="stat-card">
        <div class="stat-title">Total Revenue</div>
        <div class="stat-value">৳<?php echo number_format($total_revenue, 2); ?></div>
    </div>
    <div class="stat-card pending">
        <div class="stat-title">Pending Deposits</div>
        <div class="stat-value"><?php echo $pending_deposits; ?></div>
    </div>
    <div class="stat-card pending">
        <div class="stat-title">Pending Withdrawals</div>
        <div class="stat-value"><?php echo $pending_withdrawals; ?></div>
    </div>
</div>

<?php
require_once 'footer.php';
?>