<?php
// This is the page for adding match winners and awarding prizes.
require_once 'header.php';

// --- Validate Input and Fetch Tournament Data ---
$tournament_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($tournament_id === 0) { die("<p>Error: No tournament ID provided.</p>"); }

$tournament = $conn->query("SELECT title FROM tournaments WHERE id = $tournament_id")->fetch_assoc();
$page_title = "Results for: " . htmlspecialchars($tournament['title'] ?? 'Unknown');
echo '<script>document.querySelector(".top-header h1").textContent = "' . addslashes($page_title) . '";</script>';

// --- ACTION HANDLER ---
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $conn->begin_transaction();
    try {
        // Step 1: Clear any old winner data for this tournament to prevent duplicates.
        $conn->query("DELETE FROM match_winners WHERE tournament_id = $tournament_id");

        // Step 2: Loop through submitted data and process players who won a prize.
        foreach ($_POST['user_id'] as $index => $user_id) {
            $rank = (int)$_POST['rank'][$index];
            $kills = (int)$_POST['kills'][$index];
            $prize = (float)$_POST['prize'][$index];
            $in_game_name = $_POST['ign'][$index];

            // Only process if a prize was awarded
            if ($prize > 0) {
                // a) Insert into match_winners table
                $stmt = $conn->prepare("INSERT INTO match_winners (tournament_id, rank, in_game_name, kills, prize_awarded) VALUES (?, ?, ?, ?, ?)");
                $stmt->bind_param("iisid", $tournament_id, $rank, $in_game_name, $kills, $prize);
                $stmt->execute();
                
                // b) Update the user's balance
                $stmt = $conn->prepare("UPDATE users SET balance = balance + ? WHERE id = ?");
                $stmt->bind_param("di", $prize, $user_id);
                $stmt->execute();
                
                // c) Log the prize transaction for user history
                $desc = "Prize win for tournament #" . $tournament_id;
                $stmt = $conn->prepare("INSERT INTO transactions (user_id, amount, type, status, description) VALUES (?, ?, 'prize_win', 'completed', ?)");
                $stmt->bind_param("ids", $user_id, $prize, $desc);
                $stmt->execute();
            }
        }
        
        // If all operations succeed, commit the changes
        $conn->commit();
        echo "<div class='success-msg'>Winner results and prizes have been updated successfully!</div>";
    } catch (Exception $e) {
        $conn->rollback();
        echo "<div class='error-msg'>An error occurred: " . $e->getMessage() . "</div>";
    }
}

// --- DATA FETCHING ---
// Fetch all players registered for this tournament
$registrations_sql = "SELECT u.id as user_id, u.username, r.player_ign_data 
                      FROM registrations r 
                      JOIN users u ON r.user_id = u.id 
                      WHERE r.tournament_id = $tournament_id";
$registered_players = $conn->query($registrations_sql);

// Fetch any previously saved winner data to pre-fill the form
$winners_sql = "SELECT in_game_name, rank, kills, prize_awarded FROM match_winners WHERE tournament_id = $tournament_id";
$existing_winners_result = $conn->query($winners_sql);
$existing_winners = [];
while ($row = $existing_winners_result->fetch_assoc()) {
    $existing_winners[$row['in_game_name']] = $row; // Key by in-game name for easy lookup
}
?>
<style>
    /* Mobile-first responsive styles */
    .form-container { 
        max-width: 900px; 
        margin: auto; 
        background: var(--card-bg); 
        padding: 20px; 
        border-radius: 12px; 
        box-shadow: 0 4px 6px rgba(0,0,0,0.05); 
    }
    
    /* Desktop table view */
    .data-table { 
        width: 100%; 
        border-collapse: collapse; 
        display: table;
    }
    
    .data-table th, .data-table td { 
        padding: 12px; 
        text-align: left; 
        border-bottom: 1px solid #e5e7eb; 
    }
    
    .data-table th { 
        background: #f9fafb; 
        font-weight: 600; 
    }
    
    .data-table input { 
        padding: 8px; 
        border: 1px solid #D1D5DB; 
        border-radius: 6px; 
        font-size: 14px; 
        width: 100%; 
        box-sizing: border-box; 
    }
    
    /* Mobile card view */
    .mobile-form {
        display: none;
    }
    
    .player-form-card {
        background: #f9fafb;
        border-radius: 8px;
        padding: 15px;
        margin-bottom: 15px;
        border: 1px solid #e5e7eb;
    }
    
    .form-field {
        margin-bottom: 12px;
    }
    
    .form-field label {
        display: block;
        font-weight: 600;
        margin-bottom: 5px;
        color: var(--secondary);
        font-size: 12px;
        text-transform: uppercase;
    }
    
    .form-field input {
        padding: 10px;
        border: 1px solid #D1D5DB;
        border-radius: 6px;
        font-size: 14px;
        width: 100%;
        box-sizing: border-box;
    }
    
    .player-name {
        font-weight: 600;
        margin-bottom: 10px;
        font-size: 16px;
        color: var(--secondary);
    }
    
    .ign {
        color: #6B7280;
        font-style: italic;
        margin-bottom: 15px;
        font-size: 14px;
    }
    
    .form-actions { 
        margin-top: 25px; 
        text-align: center; 
    }
    
    .btn-submit { 
        background: var(--primary); 
        color: white; 
        padding: 12px 25px; 
        border: none; 
        border-radius: 8px; 
        font-weight: 600; 
        cursor: pointer; 
        width: 100%;
        max-width: 300px;
    }
    
    .success-msg { 
        color: #065F46; 
        background: #D1FAE5; 
        padding: 12px; 
        border-radius: 8px; 
        margin-bottom: 20px; 
        text-align: center;
    }
    
    .error-msg { 
        color: #DC2626; 
        background: #FEE2E2; 
        padding: 12px; 
        border-radius: 8px; 
        margin-bottom: 20px; 
        text-align: center;
    }
    
    /* Responsive adjustments */
    @media (max-width: 768px) {
        .data-table {
            display: none;
        }
        
        .mobile-form {
            display: block;
        }
        
        .form-container {
            padding: 15px;
        }
    }
    
    @media (max-width: 480px) {
        .player-form-card {
            padding: 12px;
        }
        
        .btn-submit {
            padding: 15px 25px;
            font-size: 16px;
        }
    }
</style>

<div class="form-container">
    <form method="POST" action="add_winners.php?id=<?php echo $tournament_id; ?>">
        <!-- Desktop Table View -->
        <div class="data-table">
            <table>
                <thead>
                    <tr>
                        <th>Player</th>
                        <th>Rank</th>
                        <th>Kills</th>
                        <th>Prize Awarded (Tk)</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $players_data = [];
                    while($player = $registered_players->fetch_assoc()): 
                        // Check if this player has existing winner data
                        $winner_data = $existing_winners[$player['player_ign_data']] ?? null;
                        $players_data[] = [
                            'player' => $player,
                            'winner_data' => $winner_data
                        ];
                    ?>
                        <tr>
                            <td>
                                <?php echo htmlspecialchars($player['username']); ?>
                                (<em><?php echo htmlspecialchars($player['player_ign_data']); ?></em>)
                                <!-- Hidden inputs to pass the user_id and ign for each row -->
                                <input type="hidden" name="user_id[]" value="<?php echo $player['user_id']; ?>">
                                <input type="hidden" name="ign[]" value="<?php echo htmlspecialchars($player['player_ign_data']); ?>">
                            </td>
                            <td>
                                <input type="number" name="rank[]" placeholder="e.g., 1" value="<?php echo htmlspecialchars($winner_data['rank'] ?? ''); ?>">
                            </td>
                            <td>
                                <input type="number" name="kills[]" placeholder="e.g., 5" value="<?php echo htmlspecialchars($winner_data['kills'] ?? '0'); ?>">
                            </td>
                            <td>
                                <input type="number" step="0.01" name="prize[]" placeholder="e.g., 500" value="<?php echo htmlspecialchars($winner_data['prize_awarded'] ?? '0.00'); ?>">
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
        
        <!-- Mobile Form View -->
        <div class="mobile-form">
            <?php foreach ($players_data as $index => $player_info): 
                $player = $player_info['player'];
                $winner_data = $player_info['winner_data'];
            ?>
                <div class="player-form-card">
                    <div class="player-name"><?php echo htmlspecialchars($player['username']); ?></div>
                    <div class="ign">IGN: <?php echo htmlspecialchars($player['player_ign_data']); ?></div>
                    
                    <input type="hidden" name="user_id[]" value="<?php echo $player['user_id']; ?>">
                    <input type="hidden" name="ign[]" value="<?php echo htmlspecialchars($player['player_ign_data']); ?>">
                    
                    <div class="form-field">
                        <label for="rank_<?php echo $index; ?>">Rank</label>
                        <input type="number" id="rank_<?php echo $index; ?>" name="rank[]" placeholder="e.g., 1" value="<?php echo htmlspecialchars($winner_data['rank'] ?? ''); ?>">
                    </div>
                    
                    <div class="form-field">
                        <label for="kills_<?php echo $index; ?>">Kills</label>
                        <input type="number" id="kills_<?php echo $index; ?>" name="kills[]" placeholder="e.g., 5" value="<?php echo htmlspecialchars($winner_data['kills'] ?? '0'); ?>">
                    </div>
                    
                    <div class="form-field">
                        <label for="prize_<?php echo $index; ?>">Prize Awarded (Tk)</label>
                        <input type="number" step="0.01" id="prize_<?php echo $index; ?>" name="prize[]" placeholder="e.g., 500" value="<?php echo htmlspecialchars($winner_data['prize_awarded'] ?? '0.00'); ?>">
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        
        <div class="form-actions">
            <button type="submit" class="btn-submit">Save Results & Award Prizes</button>
        </div>
    </form>
</div>

<?php require_once 'footer.php'; ?>