<?php

require_once 'session_check.php'; 

$user_id = $_SESSION['user_id'];
$message = '';
$message_type = 'error'; 


define('MAX_DEPOSIT_REQUESTS_PER_HOUR', 5); 


function get_user_ip() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) { return $_SERVER['HTTP_CLIENT_IP']; }
    elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) { return $_SERVER['HTTP_X_FORWARDED_FOR']; }
    else { return $_SERVER['REMOTE_ADDR']; }
}

$user_ip = get_user_ip();


$settings_sql = "SELECT setting_key, setting_value FROM settings WHERE setting_key IN ('bkash_number', 'rocket_number', 'nagad_number', 'min_deposit_amount')";
$result = $conn->query($settings_sql);
$settings = [];
if ($result) {
    while ($row = $result->fetch_assoc()) { $settings[$row['setting_key']] = $row['setting_value']; }
}
$min_deposit = $settings['min_deposit_amount'] ?? 1;



if ($_SERVER["REQUEST_METHOD"] == "POST") {

    
    
    $stmt_rate_check = $conn->prepare("SELECT COUNT(id) as count FROM deposit_logs WHERE (user_id = ? OR ip_address = ?) AND created_at > NOW() - INTERVAL 1 HOUR");
    $stmt_rate_check->bind_param("is", $user_id, $user_ip);
    $stmt_rate_check->execute();
    $result_rate = $stmt_rate_check->get_result();
    $req_count = $result_rate->fetch_assoc()['count'];
    $stmt_rate_check->close();

    if ($req_count >= MAX_DEPOSIT_REQUESTS_PER_HOUR) {
        $message = "You have made too many deposit requests. Please try again later.";
    } else {
        
        $gateway = trim($_POST['gateway']);
        $amount = filter_input(INPUT_POST, 'amount', FILTER_VALIDATE_FLOAT);
        $trxid = trim($_POST['trxid']);

        
        if (empty($gateway) || empty($trxid) || $amount === false) {
            $message = 'Please fill in all fields with valid information.';
        } elseif ($amount < $min_deposit) {
            $message = 'Minimum deposit amount is Tk ' . htmlspecialchars($min_deposit) . '.';
        } else {
            
            $sql = "INSERT INTO transactions (user_id, amount, type, status, gateway, gateway_trx_id, description) VALUES (?, ?, 'deposit', 'pending', ?, ?, ?)";
            $description = "Deposit request via $gateway";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("idsss", $user_id, $amount, $gateway, $trxid, $description);

            if ($stmt->execute()) {
                
                
                $stmt_log = $conn->prepare("INSERT INTO deposit_logs (user_id, ip_address) VALUES (?, ?)");
                $stmt_log->bind_param("is", $user_id, $user_ip);
                $stmt_log->execute();
                $stmt_log->close();

                $message = 'Your deposit request has been submitted successfully! Please wait for admin approval.';
                $message_type = 'success';
            } else {
                $message = 'An error occurred. Please try again.';
            }
            $stmt->close();
        }
    }
}
$conn->close();
?>
<html>
<head>
    <meta charset="UTF-8">
    <title>Add Money</title>

<link rel="icon" type="image/png" href="/images/favicon.png">
    <link rel="apple-touch-icon" href="/images/favicon.png">

    
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap');
        body { font-family: 'Poppins', sans-serif; background: #f4f7f9; margin: 0; padding: 20px; }
        .container { max-width: 500px; margin: auto; }
        .methods { display: flex; justify-content: space-around; margin-bottom: 20px; background: #e9ecef; border-radius: 12px; padding: 5px; }
        .methods button { flex: 1; padding: 12px; margin: 0; background: transparent; border: none; font-weight: 600; border-radius: 10px; cursor: pointer; font-size: 16px; color: #6c757d; transition: all 0.3s ease; }
        .methods button.active { background: #fff; color: #495057; box-shadow: 0 4px 8px rgba(0,0,0,0.1); }
        .panel { display: none; border-radius: 15px; color: white; padding: 20px; font-size: 14px; line-height: 1.6; }
        .panel h3, .panel label { font-size: 16px; font-weight: 600; margin-bottom: 10px; display: block; }
        .panel p { margin: 8px 0; }
        .panel input[type="text"], .panel input[type="number"] { display: block; margin-bottom: 15px; width: 100%; padding: 12px; font-size: 16px; border-radius: 10px; border: 1px solid rgba(255,255,255,0.5); background: rgba(255,255,255,0.15); color: white; box-sizing: border-box; }
        .panel input::placeholder { color: rgba(255,255,255,0.7); }
        .copy-area { display: flex; align-items: center; justify-content: center; gap: 10px; margin: 15px 0; }
        .copy-box { background: rgba(255,255,255,0.9); color: black; padding: 8px 14px; border-radius: 6px; font-weight: bold; font-size: 18px; }
        .copy-btn { background: #fff; color: #333; padding: 8px 12px; border: none; border-radius: 6px; cursor: pointer; font-weight: 600; }
        .verify-btn { background: #fff; border: none; width: 100%; margin: 20px auto 10px auto; padding: 14px; border-radius: 12px; font-size: 18px; font-weight: bold; display: block; box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2); transition: 0.3s; }
        #bkash .verify-btn { color: #ec0f75; }
        #rocket .verify-btn { color: #8124ac; }
        #nagad .verify-btn { color: #f36f20; }
        .toast { visibility: hidden; position: fixed; bottom: 30px; left: 50%; transform: translateX(-50%); background: #333; color: white; padding: 16px 25px; border-radius: 8px; box-shadow: 0 5px 15px rgba(0,0,0,0.2); z-index: 9999; opacity: 0; transition: opacity 0.3s, visibility 0.3s; }
        .toast.show { visibility: visible; opacity: 1; }
        .toast.success { background: #28a745; }
        .toast.error { background: #e74c3c; }
    </style>
</head>
<body>

<div class="container">
    <div class="methods">
        <button class="active" onclick="showPanel('bkash')">bKash</button>
        <button onclick="showPanel('rocket')">Rocket</button>
        <button onclick="showPanel('nagad')">Nagad</button>
    </div>

    
    <div id="bkash" class="panel" style="background:#ec0f75; display:block;">
        <form method="POST">
            <input type="hidden" name="gateway" value="Bkash">
            <label>Amount (Minimum: Tk <?php echo htmlspecialchars($min_deposit); ?>)</label>
            <input type="number" name="amount" placeholder="কত টাকা পাঠিয়েছেন?" required min="<?php echo htmlspecialchars($min_deposit); ?>">
            <label>Transaction ID</label>
            <input type="text" name="trxid" placeholder="ট্রানজেকশন আইডি দিন" required>
            <p>* আপনার bKash অ্যাপ থেকে <b style="color:yellow">Send Money</b> করুন।</p>
            <p>● প্রাপকের নম্বর:</p>
            <div class="copy-area">
                <div class="copy-box" id="copy_bkash"><?php echo htmlspecialchars($settings['bkash_number'] ?? 'Not Set'); ?></div>
                <button class="copy-btn" type="button" onclick="copyToClipboard('copy_bkash')">Copy</button>
            </div>
            <p>● উপরের বক্সে টাকার পরিমাণ ও Transaction ID দিন এবং VERIFY বাটনে ক্লিক করুন।</p>
            <button class="verify-btn" type="submit">VERIFY</button>
        </form>
    </div>

    
    <div id="rocket" class="panel" style="background:#8124ac; display:none;">
        <form method="POST">
            <input type="hidden" name="gateway" value="Rocket">
            <label>Amount (Minimum: Tk <?php echo htmlspecialchars($min_deposit); ?>)</label>
            <input type="number" name="amount" placeholder="কত টাকা পাঠিয়েছেন?" required min="<?php echo htmlspecialchars($min_deposit); ?>">
            <label>Transaction ID</label>
            <input type="text" name="trxid" placeholder="ট্রানজেকশন আইডি দিন" required>
            <p>* আপনার Rocket অ্যাপ থেকে <b style="color:yellow">Send Money</b> করুন।</p>
            <p>● প্রাপকের নম্বর:</p>
            <div class="copy-area">
                <div class="copy-box" id="copy_rocket"><?php echo htmlspecialchars($settings['rocket_number'] ?? 'Not Set'); ?></div>
                <button class="copy-btn" type="button" onclick="copyToClipboard('copy_rocket')">Copy</button>
            </div>
            <p>● উপরের বক্সে টাকার পরিমাণ ও Transaction ID দিন এবং VERIFY বাটনে ক্লিক করুন।</p>
            <button class="verify-btn" type="submit">VERIFY</button>
        </form>
    </div>

    
    <div id="nagad" class="panel" style="background:#f36f20; display:none;">
        <form method="POST">
            <input type="hidden" name="gateway" value="Nagad">
            <label>Amount (Minimum: Tk <?php echo htmlspecialchars($min_deposit); ?>)</label>
            <input type="number" name="amount" placeholder="কত টাকা পাঠিয়েছেন?" required min="<?php echo htmlspecialchars($min_deposit); ?>">
            <label>Transaction ID</label>
            <input type="text" name="trxid" placeholder="ট্রানজেকশন আইডি দিন" required>
            <p>* আপনার Nagad অ্যাপ থেকে <b style="color:yellow">Send Money</b> করুন।</p>
            <p>● প্রাপকের নম্বর:</p>
            <div class="copy-area">
                <div class="copy-box" id="copy_nagad"><?php echo htmlspecialchars($settings['nagad_number'] ?? 'Not Set'); ?></div>
                <button class="copy-btn" type="button" onclick="copyToClipboard('copy_nagad')">Copy</button>
            </div>
            <p>● উপরের বক্সে টাকার পরিমাণ ও Transaction ID দিন এবং VERIFY বাটনে ক্লিক করুন।</p>
            <button class="verify-btn" type="submit">VERIFY</button>
        </form>
    </div>
</div>

<div id="toast"></div>

<script>
    function showPanel(id) {
        document.querySelectorAll('.panel').forEach(p => p.style.display = 'none');
        document.getElementById(id).style.display = 'block';
        document.querySelectorAll('.methods button').forEach(btn => btn.classList.remove('active'));
        document.querySelector(`.methods button[onclick*="${id}"]`).classList.add('active');
    }

    function copyToClipboard(id) {
        const text = document.getElementById(id).innerText;
        navigator.clipboard.writeText(text).then(() => {
            showToast('Number Copied!', 'success');
        }, () => {
            showToast('Copy Failed', 'error');
        });
    }

    function showToast(message, type = '') {
        const toast = document.getElementById('toast');
        toast.textContent = message;
        toast.className = 'toast show ' + type;
        setTimeout(() => {
            toast.className = toast.className.replace('show', '');
        }, 3000);
    }

    <?php
    if (!empty($message)) {
        echo "showToast('" . addslashes($message) . "', '" . addslashes($message_type) . "');";
    }
    ?>
</script>

</body>
</html>