<?php
// --- Configuration ---
set_time_limit(60); // Attempt to increase script execution time to 60 seconds

$botToken = "8002099824:AAHcA2EyTMEm0aN6JKMqMcahABovQafZJrI"; // !!! IMPORTANT: Replace with your actual bot token !!!
$website = "https://api.telegram.org/bot".$botToken;

// Admin Chat ID (for admin-only commands) - Replace with your Telegram Chat ID
$adminChatId = "7061571573"; // Get your chat ID by messaging your bot and checking the `telegram_bot.log`

// File for storing user states (relative to this script)
$userStatesFile = 'user_states.json';
// File for general bot logs
$logFile = 'telegram_bot.log';

// --- Helper Functions ---

// Function to log messages
function logMessage($message) {
    global $logFile;
    file_put_contents($logFile, date('[Y-m-d H:i:s]') . " " . $message . PHP_EOL, FILE_APPEND);
}

// Function to make a robust Telegram API call (using file_get_contents for simplicity)
function makeApiCall($url, $method = 'GET', $params = []) {
    $fullUrl = $url;
    if ($method === 'GET' && !empty($params)) {
        $fullUrl .= '?' . http_build_query($params);
    } elseif ($method === 'POST') {
        // For POST, you'd typically use cURL. For simple URL-encoded POST, you could use stream_context_create.
        // However, for typical Telegram API calls (like sendMessage, editMessageText), GET is often sufficient,
        // or the JSON payload is sent differently. We'll stick to GET-like URL building for these functions.
        logMessage("Warning: makeApiCall used with POST method but no cURL implementation. This might not work as expected.");
    }

    $response = @file_get_contents($fullUrl); // Suppress errors with @
    if ($response === false) {
        $error = error_get_last();
        logMessage("API Call FAILED to $fullUrl. Error: " . ($error['message'] ?? 'Unknown error'));
        return false;
    }
    return json_decode($response, true);
}


// Function to load user states from JSON file
function loadUserStates() {
    global $userStatesFile;
    if (!file_exists($userStatesFile) || filesize($userStatesFile) == 0) {
        logMessage("User states file not found or empty. Initializing empty array.");
        return [];
    }
    $content = file_get_contents($userStatesFile);
    if ($content === false) {
        logMessage("Error reading user states file. Check permissions for $userStatesFile.");
        return [];
    }
    $states = json_decode($content, TRUE);
    if (!is_array($states)) {
        logMessage("User states file content is not a valid JSON array. Resetting states.");
        return [];
    }
    return $states;
}

// Function to save user states to JSON file
function saveUserStates($states) {
    global $userStatesFile;
    $result = file_put_contents($userStatesFile, json_encode($states, JSON_PRETTY_PRINT));
    if ($result === false) {
        logMessage("Error writing user states file. Check permissions for $userStatesFile.");
    }
}

// Function to get a user's current state
function getUserState($chatId) {
    $states = loadUserStates();
    return isset($states[$chatId]) ? $states[$chatId] : 'main_menu';
}

// Function to set a user's current state
function setUserState($chatId, $state) {
    $states = loadUserStates();
    $states[$chatId] = $state;
    saveUserStates($states);
    logMessage("User $chatId state set to: $state");
}

// Function to send a text message
function sendMessage($chatId, $message, $website, $keyboard = null, $replyToMessageId = null) {
    $params = [
        'chat_id' => $chatId,
        'parse_mode' => 'HTML',
        'text' => $message,
    ];
    if ($keyboard) {
        $params['reply_markup'] = json_encode($keyboard);
    }
    if ($replyToMessageId) {
        $params['reply_to_message_id'] = $replyToMessageId;
    }

    $response = makeApiCall($website.'/sendMessage', 'GET', $params);
    if ($response) {
        logMessage("Sent message to $chatId: " . $message . " | Response: " . json_encode($response));
    }
    return $response;
}

// Function to edit an existing message (useful for inline keyboards)
function editMessageText($chatId, $messageId, $text, $website, $keyboard = null) {
    $params = [
        'chat_id' => $chatId,
        'message_id' => $messageId,
        'parse_mode' => 'HTML',
        'text' => $text,
    ];
    if ($keyboard) {
        $params['reply_markup'] = json_encode($keyboard);
    }
    
    $response = makeApiCall($website.'/editMessageText', 'GET', $params);
    if ($response) {
        logMessage("Edited message $messageId for $chatId: " . $text . " | Response: " . json_encode($response));
    }
}

// Function to answer callback queries (to remove loading state from button)
function answerCallbackQuery($callbackQueryId, $website, $text = null, $showAlert = false) {
    $params = ['callback_query_id' => $callbackQueryId];
    if ($text) {
        $params['text'] = $text;
    }
    if ($showAlert) {
        $params['show_alert'] = 'true';
    }
    $response = makeApiCall($website.'/answerCallbackQuery', 'GET', $params);
    if ($response) {
        logMessage("Answered callback query $callbackQueryId | Response: " . json_encode($response));
    }
}

// --- New Function: Get Telegram File Info (Crucial for handling uploads) ---
function getFileInfo($fileId, $website) {
    $response = makeApiCall($website.'/getFile', 'GET', ['file_id' => $fileId]);
    if ($response && $response['ok']) {
        return $response['result']['file_path'] ?? null;
    }
    logMessage("Failed to get file info for file_id: $fileId. Response: " . json_encode($response));
    return null;
}


// --- Keyboard Definitions ---

// Main menu keyboard
function getMainMenuKeyboard() {
    return [
        'inline_keyboard' => [
            [['text' => 'ডিপোজিট সমস্যা', 'callback_data' => 'deposit_main_menu']],
            [['text' => 'উত্তোলন সমস্যা', 'callback_data' => 'withdrawal_main_menu']],
            [['text' => 'ওয়েবসাইট সমস্যা', 'callback_data' => 'website_main_menu']],
            [['text' => 'টুর্নামেন্ট রেজিস্ট্রেশন সমস্যা', 'callback_data' => 'registration_main_menu']],
            [['text' => 'অ্যাকাউন্ট সম্পর্কিত সমস্যা', 'callback_data' => 'account_main_menu']],
        ]
    ];
}

// Deposit Sub-menu keyboard
function getDepositMenuKeyboard() {
    return [
        'inline_keyboard' => [
            [['text' => 'ডিপোজিট সম্পূর্ণ হয়নি', 'callback_data' => 'deposit_not_credited']],
            [['text' => 'ট্রানজাকশন আইডি জমা দিন', 'callback_data' => 'deposit_submit_tx_id']],
            [['text' => 'ডিপোজিট প্রুফ দিন (স্ক্রিনশট)', 'callback_data' => 'deposit_submit_proof']],
            [['text' => '⬅️ প্রধান মেনুতে ফিরে যান', 'callback_data' => 'back_to_main_menu']]
        ]
    ];
}

// Withdrawal Sub-menu keyboard
function getWithdrawalMenuKeyboard() {
    return [
        'inline_keyboard' => [
            [['text' => 'উত্তোলন পাচ্ছি না', 'callback_data' => 'withdrawal_not_received']],
            [['text' => 'উত্তোলন সর্বনিম্ন Amount', 'callback_data' => 'withdrawal_min_amount']],
            [['text' => 'উত্তোলন প্রসেসিং সময়', 'callback_data' => 'withdrawal_processing_time']],
            [['text' => '⬅️ প্রধান মেনুতে ফিরে যান', 'callback_data' => 'back_to_main_menu']]
        ]
    ];
}

// Website Sub-menu keyboard
function getWebsiteMenuKeyboard() {
    return [
        'inline_keyboard' => [
            [['text' => 'ওয়েবসাইট খুলছে না', 'callback_data' => 'website_not_opening']],
            [['text' => 'ক্যাশ ও কুকিজ পরিষ্কার করুন', 'callback_data' => 'website_clear_cache']],
            [['text' => '⬅️ প্রধান মেনুতে ফিরে যান', 'callback_data' => 'back_to_main_menu']]
        ]
    ];
}

// Registration Sub-menu keyboard
function getRegistrationMenuKeyboard() {
    return [
        'inline_keyboard' => [
            [['text' => 'ব্যালেন্স/আইডি সমস্যা', 'callback_data' => 'registration_balance_id']],
            [['text' => 'টুর্নামেন্ট রুলস দেখুন', 'callback_data' => 'registration_view_rules']], // Example of linking to an external resource or showing more text
            [['text' => '⬅️ প্রধান মেনুতে ফিরে যান', 'callback_data' => 'back_to_main_menu']]
        ]
    ];
}

// Account Sub-menu keyboard
function getAccountMenuKeyboard() {
    return [
        'inline_keyboard' => [
            [['text' => 'পাসওয়ার্ড ভুলে গেছি', 'callback_data' => 'account_forgot_password']],
            [['text' => 'অ্যাকাউন্ট হ্যাক হয়েছে', 'callback_data' => 'account_hacked']],
            [['text' => '⬅️ প্রধান মেনুতে ফিরে যান', 'callback_data' => 'back_to_main_menu']]
        ]
    ];
}


// --- Bot Logic ---

// Read the incoming update from Telegram
$update = file_get_contents('php://input');
logMessage("Received update: " . $update);
$update = json_decode($update, TRUE);

$chatId = null;
$messageText = null;
$callbackQueryId = null;
$callbackData = null;
$messageId = null; // To edit the message that contained the inline keyboard
$fromId = null; // User ID
$isPhoto = false;
$documentFileId = null; // For documents/screenshots

if (isset($update["message"])) {
    // This is a regular message or a message with media
    $chatId = $update["message"]["chat"]["id"];
    $fromId = $update["message"]["from"]["id"];
    $messageId = $update["message"]["message_id"];

    if (isset($update["message"]["text"])) {
        $messageText = $update["message"]["text"];
    } elseif (isset($update["message"]["photo"])) {
        $isPhoto = true;
        // Get the file_id of the largest photo
        $photoArray = $update["message"]["photo"];
        $largestPhoto = end($photoArray); // Get the last (largest) photo object
        $documentFileId = $largestPhoto['file_id'];
        logMessage("Received photo from $chatId with file_id: " . $documentFileId);
    } elseif (isset($update["message"]["document"])) {
        $documentFileId = $update["message"]["document"]["file_id"];
        logMessage("Received document from $chatId with file_id: " . $documentFileId);
    }

} elseif (isset($update["callback_query"])) {
    // This is a callback query from an inline keyboard button
    $chatId = $update["callback_query"]["message"]["chat"]["id"];
    $fromId = $update["callback_query"]["from"]["id"];
    $callbackQueryId = $update["callback_query"]["id"];
    $callbackData = $update["callback_query"]["data"];
    $messageId = $update["callback_query"]["message"]["message_id"];
    logMessage("Callback Query Data for $chatId: " . $callbackData);
}

// Get current user state
$userState = getUserState($chatId);
logMessage("User $chatId current state: $userState");

// --- Process the Update ---

if ($messageText) {
    // Handle regular messages
    switch($messageText) {
        case "/start":
            $startText = "স্বাগতম! FreeFire টুর্নামেন্ট সাপোর্ট বটে আপনাকে স্বাগতম। এই বটের মাধ্যমে আপনি যেকোনো সমস্যার দ্রুত সমাধান পাবেন।";
            sendMessage($chatId, $startText, $website);
            sendMessage($chatId, "আপনার কী সমস্যা হচ্ছে? নিচের অপশনগুলি থেকে নির্বাচন করুন:", $website, getMainMenuKeyboard());
            setUserState($chatId, 'main_menu');
            break;

        case "/admin":
            if ($fromId == $adminChatId) {
                sendMessage($chatId, "এডমিন প্যানেলে স্বাগতম। এখানে আপনি অতিরিক্ত টুলস ব্যবহার করতে পারবেন।", $website);
                // Future: Add admin-specific keyboard here
            } else {
                sendMessage($chatId, "দুঃখিত, এই কমান্ডটি শুধুমাত্র এডমিনদের জন্য।", $website);
            }
            break;
            
        default:
            // Handle text input based on current state
            switch ($userState) {
                case 'awaiting_transaction_id':
                    sendMessage($chatId, "আপনার ট্রানজাকশন আইডি: `{$messageText}` আমরা এটি যাচাই করে দেখছি। সাধারণত ১০-১৫ মিনিটের মধ্যে ডিপোজিট রিফ্লেক্ট করে। এরপরও সমস্যা থাকলে, আমাদের হেল্পলাইন: <code>01711223344</code>", $website, getBackToMainMenuKeyboard());
                    setUserState($chatId, 'main_menu'); // Reset state
                    break;
                
                // Add more cases for other states expecting text input
                case 'main_menu': // If user types something in main menu state
                default:
                    $response = "দুঃখিত, আমি আপনার মেসেজ বুঝতে পারিনি। অনুগ্রহ করে নিচের অপশনগুলি থেকে নির্বাচন করুন:";
                    sendMessage($chatId, $response, $website, getMainMenuKeyboard());
                    setUserState($chatId, 'main_menu'); // Ensure state is main menu
                    break;
            }
            break;
    }
} elseif ($isPhoto || $documentFileId) {
    // Handle photos or documents
    switch ($userState) {
        case 'awaiting_deposit_screenshot':
            sendMessage($chatId, "আপনার ডিপোজিট প্রুফ পেয়েছি! আমরা এটি পর্যালোচনা করে আপনাকে দ্রুত জানাবো।", $website); // Immediate feedback to user
            
            // --- IMPORTANT: Forward the photo to the admin chat ---
            if ($adminChatId) {
                $caption = "নতুন ডিপোজিট প্রুফ এসেছে!\nব্যবহারকারী ID: $chatId";
                $sendPhotoUrl = $website."/sendPhoto?chat_id=".$adminChatId."&photo=".$documentFileId."&caption=".urlencode($caption);
                $forwardResult = makeApiCall($sendPhotoUrl);

                if ($forwardResult) {
                    logMessage("Successfully forwarded photo from $chatId to admin $adminChatId.");
                } else {
                    logMessage("Failed to forward photo from $chatId to admin $adminChatId.");
                    // You might want to inform the user if forwarding failed, though it's less critical for them.
                    // sendMessage($chatId, "দুঃখিত, আপনার প্রুফ ফরওয়ার্ড করতে সমস্যা হয়েছে। অনুগ্রহ করে আবার চেষ্টা করুন বা হেল্পলাইনে যোগাযোগ করুন।", $website);
                }
            }
            sendMessage($chatId, "আমাদের হেল্পলাইন: <code>01711223344</code>", $website, getBackToMainMenuKeyboard());
            setUserState($chatId, 'main_menu'); // Reset state
            break;
            
        default:
            // If user sends a photo/document in an unexpected state
            sendMessage($chatId, "দুঃখিত, এই মুহূর্তে আমি ছবিটি প্রক্রিয়া করতে পারছি না। অনুগ্রহ করে প্রধান মেনু থেকে আপনার সমস্যাটি নির্বাচন করুন।", $website, getMainMenuKeyboard());
            setUserState($chatId, 'main_menu');
            break;
    }

} elseif ($callbackData) {
    // Handle callback queries from inline keyboards
    answerCallbackQuery($callbackQueryId, $website); // Acknowledge the callback

    switch($callbackData) {
        case 'deposit_main_menu':
            editMessageText($chatId, $messageId, "ডিপোজিট সমস্যা সংক্রান্ত আপনার নির্দিষ্ট প্রশ্নটি নির্বাচন করুন:", $website, getDepositMenuKeyboard());
            setUserState($chatId, 'deposit_menu');
            break;
        case 'withdrawal_main_menu':
            editMessageText($chatId, $messageId, "উত্তোলন সমস্যা সংক্রান্ত আপনার নির্দিষ্ট প্রশ্নটি নির্বাচন করুন:", $website, getWithdrawalMenuKeyboard());
            setUserState($chatId, 'withdrawal_menu');
            break;
        case 'website_main_menu':
            editMessageText($chatId, $messageId, "ওয়েবসাইট সমস্যা সংক্রান্ত আপনার নির্দিষ্ট প্রশ্নটি নির্বাচন করুন:", $website, getWebsiteMenuKeyboard());
            setUserState($chatId, 'website_menu');
            break;
        case 'registration_main_menu':
            editMessageText($chatId, $messageId, "টুর্নামেন্ট রেজিস্ট্রেশন সমস্যা সংক্রান্ত আপনার নির্দিষ্ট প্রশ্নটি নির্বাচন করুন:", $website, getRegistrationMenuKeyboard());
            setUserState($chatId, 'registration_menu');
            break;
        case 'account_main_menu':
            editMessageText($chatId, $messageId, "অ্যাকাউন্ট সম্পর্কিত সমস্যা সংক্রান্ত আপনার নির্দিষ্ট প্রশ্নটি নির্বাচন করুন:", $website, getAccountMenuKeyboard());
            setUserState($chatId, 'account_menu');
            break;

        // --- Deposit Issue Sub-menu ---
        case 'deposit_not_credited':
            $response = "ডিপোজিট সমস্যার সমাধান:\n\n";
            $response .= "• প্রথমে আপনার ট্রানজাকশন আইডি চেক করুন\n";
            $response .= "• যদি পেমেন্ট সফল হয় কিন্তু ব্যালেন্স না আসে, তাহলে আমাদেরকে ট্রানজাকশন প্রুফ স্ক্রিনশট দিন\n";
            $response .= "• সাধারণত ১০-১৫ মিনিটের মধ্যে ডিপোজিট রিফ্লেক্ট করে\n";
            $response .= "• সমস্যা থাকলে আমাদের হেল্পলাইন: <code>01711223344</code>\n";
            editMessageText($chatId, $messageId, $response, $website, getDepositMenuKeyboard()); // Stay in deposit menu, or go back to main if preferred
            break;
        case 'deposit_submit_tx_id':
            editMessageText($chatId, $messageId, "অনুগ্রহ করে আপনার ট্রানজাকশন আইডিটি (Transaction ID) টাইপ করে পাঠান।", $website, getBackToMainMenuKeyboard());
            setUserState($chatId, 'awaiting_transaction_id'); // Set state to expect text input
            break;
        case 'deposit_submit_proof':
            editMessageText($chatId, $messageId, "আপনার ডিপোজিট সফল হয়েছে এমন একটি স্ক্রিনশট বা ছবি পাঠান।", $website, getBackToMainMenuKeyboard());
            setUserState($chatId, 'awaiting_deposit_screenshot'); // Set state to expect a photo
            break;

        // --- Withdrawal Issue Sub-menu ---
        case 'withdrawal_not_received':
            $response = "উত্তোলন সমস্যায় ভুগলে:\n";
            $response .= "• আপনার উত্তোলন অনুরোধের স্ট্যাটাস চেক করুন।\n";
            $response .= "• নিশ্চিত করুন যে আপনার ওয়ালেট ঠিকানা সঠিক আছে।\n";
            $response .= "• সমস্যা থাকলে আমাদের হেল্পলাইন: <code>01711223344</code>\n";
            editMessageText($chatId, $messageId, $response, $website, getWithdrawalMenuKeyboard());
            break;
        case 'withdrawal_min_amount':
            $response = "উত্তোলনের সর্বনিম্ন Amount:\n";
            $response .= "• উত্তোলনের সর্বনিম্ন Amount ১০০ টাকা\n";
            $response .= "• উত্তোলন করতে সর্বনিম্ন ৫০ ডায়মন্ড প্রয়োজন\n";
            editMessageText($chatId, $messageId, $response, $website, getWithdrawalMenuKeyboard());
            break;
        case 'withdrawal_processing_time':
            $response = "উত্তোলন প্রসেসিং সময়:\n";
            $response .= "• উত্তোলন রিকোয়েস্ট করার ২৪ ঘন্টার মধ্যে প্রসেস করা হয়। ছুটির দিনে কিছুটা সময় বেশি লাগতে পারে।\n";
            editMessageText($chatId, $messageId, $response, $website, getWithdrawalMenuKeyboard());
            break;
            
        // --- Website Issue Sub-menu ---
        case 'website_not_opening':
            $response = "যদি ওয়েবসাইট না খোলে:\n";
            $response .= "• প্রথমে আপনার ইন্টারনেট কানেকশন চেক করুন।\n";
            $response .= "• অন্য ডিভাইস বা নেটওয়ার্ক থেকে চেষ্টা করুন।\n";
            $response .= "• সমস্যা থাকলে আমাদের হেল্পলাইন: <code>01711223344</code>\n";
            editMessageText($chatId, $messageId, $response, $website, getWebsiteMenuKeyboard());
            break;
        case 'website_clear_cache':
            $response = "ব্রাউজারের ক্যাশ এবং কুকিজ পরিষ্কার করুন:\n";
            $response .= "• আপনার ব্রাউজারের সেটিংস এ যান।\n";
            $response .= "• 'Privacy and security' বা 'History' অপশনে 'Clear browsing data' খুঁজুন।\n";
            $response .= "• ক্যাশড ইমেজ এবং ফাইল, কুকিজ এবং সাইট ডেটা নির্বাচন করে পরিষ্কার করুন।\n";
            editMessageText($chatId, $messageId, $response, $website, getWebsiteMenuKeyboard());
            break;

        // --- Registration Issue Sub-menu ---
        case 'registration_balance_id':
            $response = "টুর্নামেন্ট রেজিস্ট্রেশন সমস্যা:\n\n";
            $response .= "• আপনার অ্যাকাউন্টে পর্যাপ্ত ব্যালেন্স আছে কিনা নিশ্চিত করুন।\n";
            $response .= "• রেজিস্ট্রেশনের সময় সঠিক ফ্রি ফায়ার আইডি (Player ID) দিয়েছেন কিনা চেক করুন।\n";
            $response .= "• সমস্যা থাকলে আমাদের হেল্পলাইন: <code>01711223344</code>\n";
            editMessageText($chatId, $messageId, $response, $website, getRegistrationMenuKeyboard());
            break;
        case 'registration_view_rules':
            $response = "টুর্নামেন্ট রুলস দেখতে এই লিঙ্কে ক্লিক করুন: <a href='https://yourwebsite.com/tournament_rules'>এখানে ক্লিক করুন</a>\n\n(আপনার ওয়েবসাইটের রুলস পেজের লিঙ্ক দিন)";
            editMessageText($chatId, $messageId, $response, $website, getRegistrationMenuKeyboard());
            break;

        // --- Account Issue Sub-menu ---
        case 'account_forgot_password':
            $response = "পাসওয়ার্ড ভুলে গেলে:\n\n";
            $response .= "• ওয়েবসাইটে 'Forgot Password' অপশনটি ব্যবহার করুন।\n";
            $response .= "• আপনার ইমেল বা ফোন নম্বরে একটি রিসেট লিঙ্ক পাঠানো হবে।\n";
            $response .= "• এরপরও সমস্যা থাকলে আমাদের হেল্পলাইন: <code>01711223344</code>\n";
            editMessageText($chatId, $messageId, $response, $website, getAccountMenuKeyboard());
            break;
        case 'account_hacked':
            $response = "আপনার অ্যাকাউন্ট হ্যাক হলে:\n\n";
            $response .= "• অবিলম্বে আমাদের হেল্পলাইন <code>01711223344</code> নম্বরে যোগাযোগ করুন।\n";
            $response .= "• আপনার ইউজার আইডি এবং সর্বশেষ অ্যাক্সেসের তথ্য প্রস্তুত রাখুন।\n";
            editMessageText($chatId, $messageId, $response, $website, getAccountMenuKeyboard());
            break;
            
        case 'back_to_main_menu':
            $response = "আপনার কী সমস্যা হচ্ছে? নিচের অপশনগুলি থেকে নির্বাচন করুন:";
            editMessageText($chatId, $messageId, $response, $website, getMainMenuKeyboard());
            setUserState($chatId, 'main_menu'); // Reset state to main menu
            break;

        default:
            $response = "দুঃখিত, আমি আপনার অনুরোধটি বুঝতে পারিনি।";
            editMessageText($chatId, $messageId, $response, $website, getMainMenuKeyboard());
            setUserState($chatId, 'main_menu'); // Reset state
            break;
    }
}
?>