<?php
// --- Include PHPMailer classes at the very top ---
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

// Require the PHPMailer files you uploaded
require 'PHPMailer/Exception.php';
require 'PHPMailer/PHPMailer.php';
require 'PHPMailer/SMTP.php';

require_once 'db_connect.php';
$message = '';
$message_type = 'info';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = mysqli_real_escape_string($conn, $_POST['email']);
    
    // We only need to check if the email exists. The username isn't needed here.
    $stmt = $conn->prepare("SELECT id, username FROM users WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();
    
    // Check if a user with that email exists in the database
    if ($result->num_rows === 1) {
        $user = $result->fetch_assoc();
        
        // Generate a secure token and its expiry date
        $token = bin2hex(random_bytes(32));
        $token_hash = hash('sha256', $token);
        $expires_at = date("Y-m-d H:i:s", time() + 3600); // Token expires in 1 hour
        
        // Store the hashed token in the database for the user
        $update_stmt = $conn->prepare("UPDATE users SET reset_token = ?, reset_token_expires_at = ? WHERE id = ?");
        $update_stmt->bind_param("ssi", $token_hash, $expires_at, $user['id']);
        $update_stmt->execute();
        
        // Create the full reset link to be sent in the email
        $reset_link = "https://" . $_SERVER['HTTP_HOST'] . "/reset_password.php?token=" . $token;
        
        // Create a new PHPMailer instance; passing `true` enables exceptions
        $mail = new PHPMailer(true);
        
        try {
            // --- SERVER SETTINGS WITH DEBUGGING ENABLED ---
            
            // This line is the key. It will print the full SMTP conversation.
            $mail->SMTPDebug = SMTP::DEBUG_SERVER; 
            
            $mail->isSMTP();
            $mail->Host       = 'smtp.gmail.com';
            $mail->SMTPAuth   = true;
            $mail->Username   = 'battlekingbd.mail@gmail.com'; 
            $mail->Password   = 'stkjtfcjdpjzxxir'; 
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
            $mail->Port       = 465;
            $mail->CharSet    = 'UTF-8';

            // --- RECIPIENTS ---
            $mail->setFrom('battlekingbd.mail@gmail.com', 'BattleKing BD');
            $mail->addAddress($email, $user['username']);

            // --- EMAIL CONTENT ---
            $mail->isHTML(true);
            $mail->Subject = 'Password Reset Request Verification Link';
            $mail->Body    = "Hi {$user['username']},<br><br> আপনার পাসওয়ার্ড রিসেট করতে নীচের লিঙ্কে ক্লিক করুন: <br><a href='{$reset_link}' style='background-color:#4361ee;color:white;padding:10px 15px;text-decoration:none;border-radius:5px;'>Reset My Password</a><br><br> এই লিঙ্কটির মেয়াদ ১ ঘন্টার মধ্যে শেষ হয়ে যাবে।";
            $mail->AltBody = "To reset your password, copy and paste this link into your browser: " . $reset_link;

            $mail->send();
            
            // If mail sends successfully, show a success message and stop the script.
            // In a real application, we would redirect, but for debugging we stop here.
            echo "<h1>Email Sent Successfully (Debug Mode)</h1>";
            echo "<p>If you see this message, PHPMailer successfully connected to Gmail and sent the email.</p>";
            echo "<p>Please check your inbox (and spam folder) for the reset link.</p>";
            exit();

        } catch (Exception $e) {
            // If the send() function fails, it will throw an exception.
            // This block will catch the error and display it clearly.
            // This will stop the rest of the HTML from loading so you can see the error.
            echo "<h1>Email Sending Failed</h1>";
            echo "<p>The password reset email could not be sent. The server returned the following error:</p>";
            echo "<pre style='background:#f1f1f1; padding:15px; border-radius:5px; border: 1px solid #ccc; white-space: pre-wrap; word-wrap: break-word;'>";
            echo "<strong>PHPMailer Error:</strong> " . htmlspecialchars($mail->ErrorInfo);
            echo "</pre>";
            echo "<p>Please review the SMTP debug output above for clues. Common issues are incorrect passwords (App Password required), or firewalls blocking port 465.</p>";
            exit(); // Stop the script.
        }
    }
    
    // This part of the code will only run if the email was NOT found in the database.
    // In this case, we still show a generic message for security.
    $message = "আপনার প্রদানক্রিত মেইল দিয়ে যদি আমাদের ওয়েবসাইটে অ্যাকাউন্ট থাকে, তাহলে একটি পাসওয়ার্ড রিসেট লিঙ্ক আপনার মেইলে পাঠানো হয়েছে। অনুগ্রহ করে আপনার Gmail এপ এর ইনবক্স এবং স্প্যাম ফোল্ডারটি চেক করুন।";
    $message_type = 'success';

}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Forgot Password</title>

    <link rel="icon" type="image/png" href="/images/favicon.png">
    <link rel="apple-touch-icon" href="/images/favicon.png">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap');
        
        :root {
            --primary-color: #4361ee;
            --secondary-color: #3a0ca3;
            --accent-color: #f72585;
            --light-color: #f8f9fa;
            --dark-color: #212529;
            --success-color: #4cc9f0;
            --warning-color: #f9c74f;
            --danger-color: #f94144;
            --gray-color: #adb5bd;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #0f0c29 0%, #302b63 50%, #24243e 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
            color: var(--light-color);
        }
        
        .container {
            width: 100%;
            max-width: 480px;
        }
        
        .card {
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(12px);
            border-radius: 16px;
            border: 1px solid rgba(255, 255, 255, 0.1);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.3);
            overflow: hidden;
            padding: 30px;
        }
        
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .logo {
            width: 80px;
            height: 80px;
            margin: 0 auto 15px;
            background: linear-gradient(145deg, var(--primary-color), var(--secondary-color));
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 5px 15px rgba(67, 97, 238, 0.3);
        }
        
        .logo svg {
            width: 40px;
            height: 40px;
            fill: white;
        }
        
        .title {
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 8px;
            background: linear-gradient(to right, #00f6ff, #ff00f2);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            text-shadow: 0 2px 10px rgba(0, 246, 255, 0.3);
        }
        
        .subtitle {
            font-size: 14px;
            color: var(--gray-color);
            margin-bottom: 25px;
        }
        
        .alert {
            padding: 12px 16px;
            border-radius: 10px;
            margin-bottom: 20px;
            font-size: 14px;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .alert-success {
            background: rgba(76, 201, 240, 0.15);
            border: 1px solid rgba(76, 201, 240, 0.3);
            color: #4cc9f0;
        }
        
        .alert-info {
            background: rgba(67, 97, 238, 0.15);
            border: 1px solid rgba(67, 97, 238, 0.3);
            color: #4361ee;
        }
        
        .alert-icon {
            font-size: 18px;
        }
        
        .form-group {
            margin-bottom: 20px;
            position: relative;
        }
        
        .input-with-icon {
            position: relative;
        }
        
        .input-icon {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: var(--gray-color);
            z-index: 1;
        }
        
        .form-control {
            width: 100%;
            padding: 14px 15px 14px 45px;
            background: rgba(0, 0, 0, 0.2);
            border: 1px solid rgba(255, 255, 255, 0.2);
            border-radius: 10px;
            color: var(--light-color);
            font-family: 'Poppins', sans-serif;
            font-size: 15px;
            transition: all 0.3s ease;
        }
        
        .form-control::placeholder {
            color: rgba(255, 255, 255, 0.5);
        }
        
        .form-control:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.3);
        }
        
        .btn {
            width: 100%;
            padding: 14px;
            background: linear-gradient(90deg, var(--primary-color), var(--secondary-color));
            border: none;
            border-radius: 10px;
            color: white;
            font-family: 'Poppins', sans-serif;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 8px;
        }
        
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(67, 97, 238, 0.4);
        }
        
        .btn:active {
            transform: translateY(0);
        }
        
        .footer {
            text-align: center;
            margin-top: 25px;
            font-size: 14px;
            color: var(--gray-color);
        }
        
        .footer a {
            color: var(--primary-color);
            text-decoration: none;
            transition: color 0.2s;
            font-weight: 500;
        }
        
        .footer a:hover {
            color: var(--accent-color);
            text-decoration: underline;
        }
        
        .divider {
            display: flex;
            align-items: center;
            margin: 25px 0;
            color: var(--gray-color);
            font-size: 14px;
        }
        
        .divider::before,
        .divider::after {
            content: "";
            flex: 1;
            height: 1px;
            background: rgba(255, 255, 255, 0.1);
        }
        
        .divider span {
            padding: 0 15px;
        }
        
        @media (max-width: 576px) {
            .card {
                padding: 25px 20px;
            }
            
            .title {
                font-size: 22px;
            }
            
            .subtitle {
                font-size: 13px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <div class="header">
                <div class="logo">
                    <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                        <path d="M12,1L3,5V11C3,16.55 6.84,21.74 12,23C17.16,21.74 21,16.55 21,11V5L12,1M12,7C13.4,7 14.8,8.6 14.8,10V10.5C14.8,11.9 13.4,13.1 12,13.1C10.6,13.1 9.2,11.9 9.2,10.5V10C9.2,8.6 10.6,7 12,7M12,8.2C11.2,8.2 10.5,8.7 10.5,9.5V10.5C10.5,11.3 11.2,11.8 12,11.8C12.8,11.8 13.5,11.3 13.5,10.5V10C13.5,9.2 12.8,8.7 12,8.2Z"/>
                    </svg>
                </div>
                <h1 class="title">Reset Password</h1>
                <p class="subtitle">Enter your email to receive a reset link</p>
            </div>

            <?php if (!empty($message)): ?>
                <div class="alert alert-<?php echo htmlspecialchars($message_type); ?>">
                    <span class="alert-icon">&#9432;</span>
                    <?php echo htmlspecialchars($message); ?>
                </div>
            <?php endif; ?>

            <form method="POST" action="forgot_password.php">
                <div class="form-group">
                    <div class="input-with-icon">
                        <span class="input-icon">✉</span>
                        <input type="email" name="email" class="form-control" placeholder="Email Address" required>
                    </div>
                </div>
                
                <button type="submit" class="btn">
                    <span>Send Reset Link</span>
                    <svg width="18" height="18" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M4 12H20M20 12L14 6M20 12L14 18" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </button>
            </form>
            
            <div class="divider">
                <span>OR</span>
            </div>
            
            <div class="footer">
                <p>Remember your password? <a href="login.php">Login here</a></p>
            </div>
        </div>
    </div>
</body>
</html>