<?php

session_start();
if (isset($_SESSION['user_id'])) {
    header("Location: home.php");
    exit();
}
require_once 'db_connect.php';
$error_message = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = mysqli_real_escape_string($conn, $_POST['email']);
    $password = $_POST['password'];

    if (empty($email) || empty($password)) {
        $error_message = "Please enter both email and password.";
    } else {
        $sql = "SELECT id, username, password FROM users WHERE email = ? LIMIT 1";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result && $result->num_rows == 1) {
            $user = $result->fetch_assoc();
            if (password_verify($password, $user['password'])) {
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['username'] = $user['username'];
                header("Location: home.php");
                exit();
            }
        }
        $error_message = "Invalid email or password.";
        $stmt->close();
    }
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Login</title>

<link rel="icon" type="image/png" href="/images/favicon.png">
    <link rel="apple-touch-icon" href="/images/favicon.png">

    
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap');
        :root {
            --primary-glow: #00f6ff;
            --secondary-glow: #ff00f2;
        }
        * { box-sizing: border-box; }
        body {
            font-family: 'Poppins', sans-serif;
            margin: 0;
            background-color: #0f0c29;
            background-image: linear-gradient(160deg, #0f0c29 0%, #302b63 50%, #24243e 100%);
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            padding: 20px;
        }
        .login-container {
            width: 100%;
            max-width: 420px;
            padding: 40px 30px;
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(10px);
            border-radius: 20px;
            border: 1px solid rgba(255, 255, 255, 0.1);
            box-shadow: 0 8px 32px 0 rgba(0, 0, 0, 0.37);
            text-align: center;
            color: #fff;
        }
        
        
        .logo-header {
            margin-bottom: 20px;
        }
        .logo-img {
            width: 90px;
            height: 90px;
            border-radius: 50%;
            border: 2px solid rgba(255, 255, 255, 0.2);
            box-shadow: 0 0 15px rgba(0, 246, 255, 0.3);
            object-fit: cover;
        }
        .site-name {
            margin-top: 10px;
            font-size: 20px;
            font-weight: 500;
            letter-spacing: 1px;
            color: #fff;
        }

        .login-container h2 {
            margin-top: 0;
            margin-bottom: 25px;
            font-size: 28px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 2px;
            text-shadow: 0 0 5px var(--primary-glow);
        }
        .input-group { position: relative; margin-bottom: 20px; }
        .input-group svg { position: absolute; left: 15px; top: 50%; transform: translateY(-50%); width: 20px; height: 20px; fill: rgba(255, 255, 255, 0.5); }
        .input-field { width: 100%; padding: 14px 15px 14px 50px; background: rgba(0, 0, 0, 0.2); border: 1px solid rgba(255, 255, 255, 0.3); border-radius: 10px; color: #fff; font-size: 16px; transition: all 0.3s ease; }
        .input-field::placeholder { color: rgba(255, 255, 255, 0.5); }
        .input-field:focus { outline: none; border-color: var(--primary-glow); box-shadow: 0 0 15px rgba(0, 246, 255, 0.5); }
        .submit-btn { width: 100%; padding: 14px; background-image: linear-gradient(90deg, var(--primary-glow), var(--secondary-glow)); border: none; border-radius: 10px; color: #fff; font-size: 18px; font-weight: 600; text-transform: uppercase; cursor: pointer; transition: all 0.3s ease; }
        .submit-btn:hover { box-shadow: 0 0 20px rgba(0, 246, 255, 0.7); transform: scale(1.02); }
        .footer-links { margin-top: 25px; font-size: 14px; }
        .footer-links a { color: var(--primary-glow); text-decoration: none; font-weight: 500; transition: color 0.2s; }
        .footer-links a:hover { color: var(--secondary-glow); text-decoration: underline; }
        .msg.error { background: rgba(231, 76, 60, 0.2); color: #f8b4b4; border: 1px solid rgba(231, 76, 60, 0.5); padding: 10px; border-radius: 8px; margin-bottom: 20px; font-size: 14px; }
 .options-link {
            text-align: right;
            margin-top: -10px;
            margin-bottom: 20px;
        }
        .options-link a {
            color: #ccc;
            text-decoration: none;
            font-size: 13px;
            transition: color 0.2s;
        }
        .options-link a:hover {
            color: var(--primary-glow);
        }


    </style>
</head>
<body>
    <div class="login-container">
        
        <div class="logo-header">
            
            <img src="images/logo.png" alt="Website Logo" class="logo-img">
            
            <h3 class="site-name">Battle King BD</h3>
        </div>

        <h2>Login</h2>
        
        <?php if (!empty($error_message)): ?>
            <div class="msg error"><?php echo htmlspecialchars($error_message); ?></div>
        <?php endif; ?>

        <form method="POST" action="login.php">
            <div class="input-group">
                <svg viewBox="0 0 24 24"><path d="M20,4H4A2,2,0,0,0,2,6V18a2,2,0,0,0,2,2H20a2,2,0,0,0,2-2V6A2,2,0,0,0,20,4Zm0,14H4V8l8,5,8-5Z"></path></svg>
                <input class="input-field" type="email" name="email" placeholder="Email Address" required>
            </div>
            <div class="input-group">
                <svg viewBox="0 0 24 24"><path d="M12,17c1.1,0,2-.9,2-2s-.9-2-2-2-2,.9-2,2,.9,2,2,2Zm6-9h-1V6c0-2.76-2.24-5-5-5S7,3.24,7,6v2H6c-1.1,0-2,.9-2,2v10c0,1.1,.9,2,2,2h12c1.1,0,2-.9,2-2V10c0-1.1-.9-2-2-2Zm-6,9c-1.66,0-3-1.34-3-3s1.34-3,3-3,3,1.34,3,3-1.34,3-3,3Zm3.1-9H8.9V6c0-1.71,1.39-3.1,3.1-3.1s3.1,1.39,3.1,3.1v2Z"></path></svg>
                <input class="input-field" type="password" name="password" placeholder="Password" required>
            </div>

<div class="options-link">
                <a href="forgot_password.php">Forgot Password?</a>
            </div>

            <button class="submit-btn" type="submit">Log In</button>
        </form>
        <div class="footer-links">
            <p>Don't have an account? <a href="register.php">Sign Up</a></p>
        </div>
    </div>
</body>
</html>