<?php
// Password Hash Generator
// Save this as hash_generator.php

// Check if form was submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $password = $_POST['password'] ?? '';
    $algorithm = $_POST['algorithm'] ?? PASSWORD_DEFAULT;
    $options = [];

    // Set cost parameter if provided
    if (isset($_POST['cost']) && is_numeric($_POST['cost'])) {
        $options['cost'] = (int)$_POST['cost'];
    }

    // Generate the hash
    $hash = password_hash($password, $algorithm, $options);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Password Hash Generator</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px; }
        .container { background: #f9f9f9; padding: 20px; border-radius: 5px; }
        .form-group { margin-bottom: 15px; }
        label { display: block; margin-bottom: 5px; }
        input[type="password"], select { width: 100%; padding: 8px; box-sizing: border-box; }
        button { background: #4CAF50; color: white; padding: 10px 15px; border: none; border-radius: 4px; cursor: pointer; }
        button:hover { background: #45a049; }
        .result { margin-top: 20px; padding: 10px; background: #e9ffe9; border: 1px solid #d4edda; border-radius: 4px; }
    </style>
</head>
<body>
    <div class="container">
        <h1>Password Hash Generator</h1>
        <form method="post">
            <div class="form-group">
                <label for="password">Password:</label>
                <input type="password" id="password" name="password" required>
            </div>
            
            <div class="form-group">
                <label for="algorithm">Hashing Algorithm:</label>
                <select id="algorithm" name="algorithm">
                    <option value="<?= PASSWORD_DEFAULT ?>">Default (<?= PASSWORD_DEFAULT ?>)</option>
                    <option value="<?= PASSWORD_BCRYPT ?>">BCRYPT (<?= PASSWORD_BCRYPT ?>)</option>
                    <?php if (defined('PASSWORD_ARGON2I')): ?>
                    <option value="<?= PASSWORD_ARGON2I ?>">Argon2i (<?= PASSWORD_ARGON2I ?>)</option>
                    <?php endif; ?>
                    <?php if (defined('PASSWORD_ARGON2ID')): ?>
                    <option value="<?= PASSWORD_ARGON2ID ?>">Argon2id (<?= PASSWORD_ARGON2ID ?>)</option>
                    <?php endif; ?>
                </select>
            </div>
            
            <div class="form-group">
                <label for="cost">Cost (for BCRYPT, between 4 and 31):</label>
                <input type="number" id="cost" name="cost" min="4" max="31" value="12">
            </div>
            
            <button type="submit">Generate Hash</button>
        </form>
        
        <?php if (isset($hash)): ?>
        <div class="result">
            <h3>Generated Hash:</h3>
            <p><strong>Password:</strong> <?= htmlspecialchars($password) ?></p>
            <p><strong>Hash:</strong> <?= htmlspecialchars($hash) ?></p>
            <p><strong>Algorithm:</strong> <?= $algorithm ?></p>
            <?php if (isset($options['cost'])): ?>
            <p><strong>Cost:</strong> <?= $options['cost'] ?></p>
            <?php endif; ?>
            <p><strong>Verification:</strong> 
                <?= password_verify($password, $hash) ? '✅ Verified' : '❌ Verification failed' ?>
            </p>
        </div>
        <?php endif; ?>
    </div>
</body>
</html>