<?php


session_start();
require_once 'session_check.php';


if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}
$user_id = $_SESSION['user_id'];
$message = '';
$message_type = 'error'; 


$user_sql = "SELECT balance FROM users WHERE id = ?";
$stmt = $conn->prepare($user_sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user_balance = $stmt->get_result()->fetch_assoc()['balance'] ?? 0;

$setting_sql = "SELECT setting_value FROM settings WHERE setting_key = 'min_withdraw_amount' LIMIT 1";
$min_withdraw_amount = $conn->query($setting_sql)->fetch_assoc()['setting_value'] ?? 500;



if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $method = trim($_POST['method']);
    $number = trim($_POST['number']);
    $amount = filter_input(INPUT_POST, 'amount', FILTER_VALIDATE_FLOAT);

    
    if (empty($method) || empty($number) || $amount === false) {
        $message = 'Please fill in all the fields.';
    } elseif (!preg_match('/^01[3-9]\d{8}$/', $number)) {
        $message = 'Please enter a valid 11-digit mobile number.';
    } elseif ($amount < $min_withdraw_amount) {
        $message = "Minimum withdrawal amount is BDT " . htmlspecialchars($min_withdraw_amount) . ".";
    } elseif ($amount > $user_balance) {
        $message = "You do not have sufficient balance to withdraw this amount.";
    } else {
        
        $conn->begin_transaction();
        try {
            
            $new_balance = $user_balance - $amount;
            $update_sql = "UPDATE users SET balance = ? WHERE id = ?";
            $stmt = $conn->prepare($update_sql);
            $stmt->bind_param("di", $new_balance, $user_id);
            $stmt->execute();

            
            $withdrawal_amount = -$amount;
            $description = "Withdrawal request to $method number: $number";
            $insert_sql = "INSERT INTO transactions (user_id, amount, type, status, gateway, description) 
                           VALUES (?, ?, 'withdrawal', 'pending', ?, ?)";
            $stmt = $conn->prepare($insert_sql);
            $stmt->bind_param("idss", $user_id, $withdrawal_amount, $method, $description);
            $stmt->execute();

            
            $conn->commit();
            $message = 'Withdrawal request submitted successfully! It will be processed by an admin shortly.';
            $message_type = 'success';
            
            $user_balance = $new_balance; 

        } catch (Exception $e) {
            
            $conn->rollback();
            $message = "An error occurred. Please try again later.";
        }
    }
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title> Withdraw</title>

<link rel="icon" type="image/png" href="/images/favicon.png">
    <link rel="apple-touch-icon" href="/images/favicon.png">


    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap');
        :root {
            --primary-color: #7c3aed;
            --accent-color: #ff7c2a;
            --background-color: #f4f7f9;
        }
        body { margin: 0; font-family: 'Poppins', sans-serif; background: var(--background-color); }
        .box { max-width: 420px; margin: 40px auto; background: white; padding: 25px 30px; border-radius: 20px; box-shadow: 0 10px 30px rgba(0,0,0,0.08); text-align: center; }
        .amount-box { background: #f8faff; padding: 15px; border-radius: 15px; margin-bottom: 25px; font-weight: 500; color: #555; border: 1px solid #eaf0f9; }
        .amount-box span { font-size: 28px; color: #1abc9c; font-weight: 600; display: block; }
        .methods { display: flex; justify-content: center; margin-bottom: 25px; gap: 10px; }
        .method label { position: relative; }
        .method input { position: absolute; opacity: 0; width: 0; height: 0; }
        .method span { display: inline-block; padding: 10px 20px; border: 2px solid #e0e0e0; border-radius: 12px; cursor: pointer; font-weight: 500; transition: all 0.3s ease; }
        .method input:checked + span { border-color: var(--primary-color); background: var(--primary-color); color: white; box-shadow: 0 4px 10px rgba(124, 58, 237, 0.3); }
        input[type="text"], input[type="number"] { width: 100%; box-sizing: border-box; padding: 14px; margin-bottom: 15px; border-radius: 10px; border: 1.5px solid #d0d0d0; font-size: 16px; transition: border-color 0.3s, box-shadow 0.3s; }
        input:focus { border-color: var(--primary-color); box-shadow: 0 0 0 3px rgba(124, 58, 237, 0.15); outline: none; }
        .btn { background: var(--accent-color); color: white; padding: 14px; border: none; width: 100%; border-radius: 30px; font-size: 17px; font-weight: 600; cursor: pointer; transition: background 0.3s, transform 0.2s; }
        .btn:hover { background: #fa6c0f; transform: translateY(-2px); }
        .note { font-size: 13px; color: #666; margin-top: 15px; }
        .msg { padding: 12px; border-radius: 10px; margin-bottom: 20px; font-weight: 500; font-size: 14px; text-align: left; }
        .msg.success { background: #d1f7d1; color: #146c2d; border-left: 5px solid #28a745; }
        .msg.error { background: #f8d7da; color: #721c24; border-left: 5px solid #dc3545; }
    </style>
</head>
<body>

<div class="box">
    <div class="amount-box">
        Available for Withdrawal<br>
        <span>৳<?php echo htmlspecialchars(number_format($user_balance, 2)); ?></span>
    </div>

    
    <?php if (!empty($message)): ?>
        <div class="msg <?php echo $message_type; ?>"><?php echo htmlspecialchars($message); ?></div>
    <?php endif; ?>
  
    <form method="POST">
        <div class="methods">
            <div class="method">
                <label><input type="radio" name="method" value="bkash" checked><span>bKash</span></label>
            </div>
            <div class="method">
                <label><input type="radio" name="method" value="nagad"><span>Nagad</span></label>
            </div>
            <div class="method">
                <label><input type="radio" name="method" value="rocket"><span>Rocket</span></label>
            </div>
        </div>

        <input type="text" name="number" placeholder="Enter Payment Number" pattern="01[3-9]\d{8}" title="Must be a valid 11-digit number" required>
        <input type="number" name="amount" placeholder="Withdrawal Amount" min="<?php echo htmlspecialchars($min_withdraw_amount); ?>" required>
        
        <button type="submit" class="btn">Submit Request</button>

        <div class="note">* Minimum withdrawal is ৳<?php echo htmlspecialchars($min_withdraw_amount); ?>. Service charge may apply.</div>
    </form>
</div>

</body>
</html>