<?php
/*
 * Admin Login
 * /admin/login.php
 * FINAL VERSION
 */

//  --- Step 1: Start the session ---
//  There should be NO whitespace or any other character before this line.
session_start();

//  --- Step 2: Check if already logged in ---
if (isset($_SESSION['admin_id'])) {
    header("Location: index.php");
    exit(); // Always exit after a redirect
}

// --- Step 3: Include the database connection ---
// We do this *after* starting the session and checking login status.
require_once '../db_connect.php';

$error_message = '';

// --- Step 4: Process form submission ---
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = trim($_POST['username']);
    $password = $_POST['password'];

    if (empty($username) || empty($password)) {
        $error_message = "Username and Password are required.";
    } else {
        $sql = "SELECT id, username, password FROM admin_users WHERE username = ? LIMIT 1";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result && $result->num_rows == 1) {
            $admin = $result->fetch_assoc();

            if (password_verify($password, $admin['password'])) {
                // --- SUCCESS ---
                // Regenerate session ID for security after login
                session_regenerate_id(true); 
                
                // Set session variables
                $_SESSION['admin_id'] = $admin['id'];
                $_SESSION['admin_username'] = $admin['username'];
                
                // Redirect to the main dashboard
                header("Location: index.php");
                exit(); // CRITICAL: Stop the script immediately
            } else {
                $error_message = "Invalid credentials.";
            }
        } else {
            $error_message = "Invalid credentials.";
        }
        $stmt->close();
    }
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Hunter BD71 - Admin</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap');
        body { font-family: 'Poppins', sans-serif; background-color: #f0f2f5; display: flex; justify-content: center; align-items: center; height: 100vh; margin: 0; }
        .login-card { background: white; padding: 40px 30px; border-radius: 16px; box-shadow: 0 10px 30px rgba(0,0,0,0.1); width: 100%; max-width: 380px; text-align: center; }
        .login-card h2 { margin: 0 0 10px; font-size: 24px; color: #333; }
        .login-card p { color: #666; margin-bottom: 30px; }
        .input-group { margin-bottom: 20px; text-align: left; }
        .input-group label { display: block; margin-bottom: 8px; font-weight: 500; color: #555; }
        .input-group input { width: 100%; padding: 12px 15px; border: 1px solid #ccc; border-radius: 8px; font-size: 16px; box-sizing: border-box; }
        .btn { width: 100%; padding: 14px; background: #2c3e50; color: white; border: none; border-radius: 8px; font-size: 16px; font-weight: 600; cursor: pointer; transition: background 0.3s; }
        .btn:hover { background: #34495e; }
        .error-msg { color: #e74c3c; background: #fdd; padding: 10px; border-radius: 8px; margin-bottom: 20px; }
    </style>
</head>
<body>
    <div class="login-card">
        <h2>Hunter BD71 - Admin</h2>
        <p>Sign in to access admin</p>
        <?php if(!empty($error_message)): ?>
            <div class="error-msg"><?php echo htmlspecialchars($error_message); ?></div>
        <?php endif; ?>
        <form method="POST" action="login.php">
            <div class="input-group">
                <label for="username">Username</label>
                <input type="text" id="username" name="username" required>
            </div>
            <div class="input-group">
                <label for="password">Password</label>
                <input type="password" id="password" name="password" required>
            </div>
            <button type="submit" class="btn">Login</button>
        </form>
    </div>
</body>
</html>