<?php

session_start();
require_once 'session_check.php';
require_once 'db_connect.php'; 


$rules_result = $conn->query("SELECT id, rule_name, rule_content FROM match_rules ORDER BY id ASC");

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>All Match Rules</title>

<link rel="icon" type="image/png" href="/images/favicon.png">
    <link rel="apple-touch-icon" href="/images/favicon.png">


    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Montserrat:wght@500;700&display=swap');
        body { margin: 0; font-family: 'Montserrat', sans-serif; background: #f7f9fc; color: #2c3e50; }
        .page-header { background: linear-gradient(135deg, #6366F1, #8e44ad); color: white; padding: 25px 20px; text-align: center; }
        .page-header h1 { margin: 0; font-size: 24px; }
        .content-wrapper { padding: 20px; }
        .rule-card {
            background: white;
            border-radius: 16px;
            margin-bottom: 20px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.05);
        }
        .rule-title {
            padding: 15px 20px;
            font-size: 18px;
            font-weight: 700;
            cursor: pointer;
            border-bottom: 1px solid #eee;
            position: relative;
        }
        .rule-title::after {
            content: '+';
            position: absolute;
            right: 20px;
            font-size: 24px;
            transition: transform 0.3s;
        }
        .rule-title.active::after {
            transform: rotate(45deg);
        }
        .rule-content {
            padding: 0 20px;
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.4s ease-out, padding 0.4s ease-out;
            line-height: 1.6;
        }
        .bottom-nav { position: fixed; bottom: 0; left: 0; right: 0; background: white; display: flex; justify-content: space-around; border-top: 1px solid #eee; padding: 8px 0; box-shadow: 0 -2px 8px rgba(0, 0, 0, 0.05); }
        .bottom-nav a { text-align: center; text-decoration: none; color: #333; font-size: 12px; font-weight: 500; display: flex; flex-direction: column; align-items: center; }
        .bottom-nav img { width: 24px; height: 24px; margin-bottom: 4px; }
        .bottom-nav a.active { color: #2980b9; }
    </style>
</head>
<body>

<div class="page-header">
    <h1>All Match Rules</h1>
</div>

<div class="content-wrapper">
    <?php if ($rules_result && $rules_result->num_rows > 0): ?>
        <?php while($rule = $rules_result->fetch_assoc()): ?>
            <div class="rule-card">
                <div class="rule-title"><?php echo htmlspecialchars($rule['rule_name']); ?></div>
                <div class="rule-content">
                    <p><?php echo nl2br(htmlspecialchars($rule['rule_content'])); ?></p>
                </div>
            </div>
        <?php endwhile; ?>
    <?php else: ?>
        <p style="text-align: center;">No match rules have been defined yet.</p>
    <?php endif; ?>
</div>

<div class="bottom-nav">
    <a href="home.php"><img src="icons/play.png"><span>Play</span></a>
    <a href="my-matches.php"><img src="icons/match.png"><span>Matches</span></a>
    <a href="results.php"><img src="icons/results.png"><span>Results</span></a>
    <a href="profile.php" class="active"><img src="icons/profile.png"><span>Profile</span></a>
</div>

<script>
    
    document.addEventListener('DOMContentLoaded', function() {
        const ruleTitles = document.querySelectorAll('.rule-title');
        ruleTitles.forEach(title => {
            title.addEventListener('click', () => {
                const content = title.nextElementSibling;
                const isActive = title.classList.contains('active');

                
                // ruleTitles.forEach(t => {
                //     t.classList.remove('active');
                //     t.nextElementSibling.style.maxHeight = null;
                //     t.nextElementSibling.style.padding = '0 20px';
                // });

                if (!isActive) {
                    title.classList.add('active');
                    content.style.padding = '15px 20px';
                    content.style.maxHeight = content.scrollHeight + "px";
                } else {
                    title.classList.remove('active');
                    content.style.maxHeight = null;
                    content.style.padding = '0 20px';
                }
            });
        });
    });
</script>

</body>
</html>
<?php $conn->close(); ?>