<?php


session_start();
require_once 'db_connect.php';


if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}
$user_id = $_SESSION['user_id'];
$message = '';
$message_type = 'error'; 


$sql = "SELECT username, email, mobile_number, password FROM users WHERE id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();

if (!$user) {
    die("Error: Could not retrieve user data.");
}


if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $old_password = $_POST['old_password'];
    $new_password = $_POST['new_password'];
    $confirm_password = $_POST['confirm_password'];

    
    if (!password_verify($old_password, $user['password'])) {
        $message = 'Incorrect old password.';
    } elseif (strlen($new_password) < 6) {
        $message = 'New password must be at least 6 characters long.';
    } elseif ($new_password !== $confirm_password) {
        $message = 'New passwords do not match.';
    } else {
        
        
        
        $new_hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
        
        $update_sql = "UPDATE users SET password = ? WHERE id = ?";
        $stmt = $conn->prepare($update_sql);
        $stmt->bind_param("si", $new_hashed_password, $user_id);
        
        if ($stmt->execute()) {
            $message = 'Password changed successfully!';
            $message_type = 'success';
            
            $user['password'] = $new_hashed_password;
        } else {
            $message = 'An error occurred. Please try again.';
        }
    }
}
$conn->close();
?>
<html>
<head>
    <meta charset="UTF-8">
    <title>Edit - Profile</title>

<link rel="icon" type="image/png" href="/images/favicon.png">
    <link rel="apple-touch-icon" href="/images/favicon.png">


    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap');
        :root {
            --primary-color: #6c5ce7;
            --background-color: #f4f7f9;
        }
        body {
            margin: 0;
            padding: 20px;
            background: var(--background-color);
            font-family: 'Poppins', sans-serif;
            display: flex;
            justify-content: center;
            align-items: flex-start;
            min-height: 100vh;
        }
        .profile-box {
            background: white;
            max-width: 420px;
            width: 100%;
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.07);
            padding: 30px;
            box-sizing: border-box;
        }
        .page-header {
            text-align: center;
            margin: 0 0 30px 0;
            font-size: 24px;
            font-weight: 600;
            color: #2d2d2d;
        }
        .section-title {
            margin: 25px 0 15px;
            color: #555;
            font-size: 14px;
            font-weight: 500;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            text-align: left;
            border-bottom: 1px solid #eee;
            padding-bottom: 8px;
        }
        .profile-box input[type="text"],
        .profile-box input[type="email"],
        .profile-box input[type="password"] {
            width: 100%;
            padding: 13px 16px;
            margin-bottom: 15px;
            font-size: 15px;
            border: 1px solid #e0e0e0;
            border-radius: 12px;
            background-color: #f9fafb;
            box-sizing: border-box;
            transition: border-color 0.3s, box-shadow 0.3s;
        }
        .profile-box input:focus {
            outline: none;
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(108, 92, 231, 0.15);
        }
        input[readonly] {
            background-color: #f0f1f3;
            color: #444;
            cursor: not-allowed;
        }
        .btn {
            width: 100%;
            padding: 14px;
            background: #2d2d2d;
            color: white;
            font-size: 16px;
            font-weight: 600;
            border: none;
            border-radius: 12px;
            cursor: pointer;
            transition: background 0.3s, transform 0.2s;
        }
        .btn:hover {
            background: #000;
            transform: translateY(-2px);
        }
        .msg {
            padding: 12px;
            margin-bottom: 20px;
            border-radius: 10px;
            font-weight: 500;
            font-size: 14px;
            border-left: 5px solid;
        }
        .msg.success { background-color: #d1f7d1; color: #146c2d; border-color: #28a745; }
        .msg.error { background-color: #f8d7da; color: #721c24; border-color: #dc3545; }
    </style>
</head>
<body>

<div class="profile-box">
    <h2 class="page-header">My Profile</h2>

    
    <?php if (!empty($message)): ?>
        <div class="msg <?php echo $message_type; ?>"><?php echo htmlspecialchars($message); ?></div>
    <?php endif; ?>

    <h3 class="section-title">Basic Details</h3>
    <input type="text" value="<?php echo htmlspecialchars($user['username']); ?>" readonly>
    <input type="email" value="<?php echo htmlspecialchars($user['email']); ?>" readonly>
    <input type="text" value="<?php echo htmlspecialchars($user['mobile_number']); ?>" readonly>

    <h3 class="section-title">Password Change</h3>
    <form method="POST">
        <input type="password" name="old_password" placeholder="Old Password" required>
        <input type="password" name="new_password" placeholder="New Password" required>
        <input type="password" name="confirm_password" placeholder="Confirm New Password" required>
        <button type="submit" class="btn">Change Password</button>
    </form>
</div>

</body>
</html>