<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Privacy Policy - Hunter BD71</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="/images/favicon.png">
    <style>
        
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap');
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f4f7f9;
            color: #333;
            line-height: 1.7;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 800px;
            margin: 40px auto;
            background: white;
            padding: 20px 40px;
            border-radius: 12px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.05);
        }
        h1, h2 {
            color: #1d2129;
            border-bottom: 2px solid #e9ecef;
            padding-bottom: 10px;
        }
        h1 {
            text-align: center;
            font-size: 28px;
        }
        h2 {
            font-size: 22px;
            margin-top: 30px;
        }
        p, li {
            font-size: 16px;
            color: #555;
        }
        a {
            color: #6c5ce7;
            text-decoration: none;
        }
        a:hover {
            text-decoration: underline;
        }
        .last-updated {
            text-align: center;
            font-size: 14px;
            color: #777;
            margin-top: -15px;
            margin-bottom: 25px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Privacy Policy for Khelo FF</h1>
        <p class="last-updated">Last Updated: <?php echo date("F j, Y"); ?></p>

        <p>Welcome to Khelo FF. We are committed to protecting your privacy and handling your data in an open and transparent manner. This privacy policy explains what information we collect from you, how we use it, and the steps we take to ensure it is kept secure.</p>

        <h2>1. Information We Collect</h2>
        <p>We collect information in the following ways:</p>
        <ul>
            <li><strong>Information you provide to us directly:</strong> This includes the personal details you provide when you create an account, such as your first and last name, username, email address, and mobile number.</li>
            <li><strong>Information collected automatically for security:</strong> To protect our service and users from spam, fraud, and automated abuse, our servers automatically log certain information. This includes your **IP address** and the timestamps of certain activities, such as account registration and deposit requests.</li>
            <li><strong>Transaction Information:</strong> We maintain a history of your financial activities on the site, including deposits, withdrawals, match entry fees, and prize winnings, to manage your account balance.</li>
        </ul>

        <h2>2. How We Use Your Information</h2>
        <p>We use the information we collect for the following purposes:</p>
        <ul>
            <li><strong>To provide and manage your account:</strong> Your registration details allow us to create and maintain your account and user profile.</li>
            <li><strong>To operate the tournament service:</strong> We use your in-game name to manage match registrations and to display winner lists.</li>
            <li><strong>To process transactions:</strong> Your financial history is necessary to accurately manage your wallet balance.</li>
            <li><strong>For security and fraud prevention:</strong> We use your IP address to implement rate limiting on registration and deposit forms. This is a crucial security measure to prevent bots and protect our platform from automated spam and abuse.</li>
            <li><strong>To communicate with you:</strong> We may use your email address to send important information, such as password reset links.</li>
        </ul>

        <h2>3. Data Security</h2>
        <p>We take the security of your data very seriously. We implement the following measures to protect your information:</p>
        <ul>
            <li><strong>Password Hashing:</strong> Your password is never stored as plain text. It is encrypted using a strong, one-way hashing algorithm (BCRYPT). Even we cannot see your real password.</li>
            <li><strong>Secure Connections:</strong> When available, we use SSL/TLS (HTTPS) to encrypt data transmitted between your browser and our server.</li>
            <li><strong>Access Control:</strong> Access to personal user data is restricted to authorized administrative staff who require it to perform their duties.</li>
        </ul>

        <h2>4. Data Sharing and Third Parties</h2>
        <p>We do not sell, trade, or rent your personal identification information to others. We may share information with third-party service providers only when necessary to operate our service, such as with a payment gateway to process a deposit.</p>

        <h2>5. Your Rights</h2>
        <p>You have the right to access and update the information in your user profile. If you wish to delete your account, please contact us. Please note that for security and financial record-keeping, some transaction data may be retained for a period of time as required by law or for legitimate business purposes.</p>
        
        <h2>6. Changes to This Privacy Policy</h2>
        <p>We may update this privacy policy from time to time. We will notify you of any changes by posting the new policy on this page. We encourage you to review this policy periodically for any changes.</p>

        <h2>7. Contact Us</h2>
        <p>If you have any questions about this Privacy Policy, please do not hesitate to contact us at: </p> <a href="https://t.me/raf1n_12" <p> Telegram </p>
        <a href="#" <p2> Whatsapp </p2>
    </div>
</body>
</html>