<?php
require_once 'session_check.php'; 
$user_id = $_SESSION['user_id'];
$message = '';
$message_type = 'info';

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['claim_referral'])) {
    $referral_id_to_claim = (int)$_POST['referral_id'];
    $conn->begin_transaction();

    try {
        $stmt_check = $conn->prepare("SELECT id FROM referrals WHERE id = ? AND referrer_id = ? AND status = 'eligible' FOR UPDATE");
        $stmt_check->bind_param("ii", $referral_id_to_claim, $user_id);
        $stmt_check->execute();
        $referral_to_claim = $stmt_check->get_result();

        if ($referral_to_claim->num_rows === 1) {
            $stmt_update_ref = $conn->prepare("UPDATE referrals SET status = 'claimed' WHERE id = ?");
            $stmt_update_ref->bind_param("i", $referral_id_to_claim);
            if (!$stmt_update_ref->execute()) { throw new Exception("Failed to update referral status."); }

            $stmt_update_bal = $conn->prepare("UPDATE users SET balance = balance + 5 WHERE id = ?");
            $stmt_update_bal->bind_param("i", $user_id);
            if (!$stmt_update_bal->execute()) { throw new Exception("Failed to update user balance."); }

            $desc = "Referral bonus from referral #" . $referral_id_to_claim;
            $stmt_log_txn = $conn->prepare("INSERT INTO transactions (user_id, amount, type, description, status) VALUES (?, 5, 'referral_bonus', ?, 'completed')");
            $stmt_log_txn->bind_param("is", $user_id, $desc);
            if (!$stmt_log_txn->execute()) { throw new Exception("Failed to log transaction."); }

            $conn->commit();
            $message = "Success! Tk 5 reward has been added to your wallet.";
            $message_type = 'success';
        } else {
            throw new Exception("This reward is not available to be claimed.");
        }
    } catch (Exception $e) {
        $conn->rollback();
        $message = "Error: Could not claim the reward. " . $e->getMessage();
        $message_type = 'error';
    }
}

$my_referral_code = '';
$stmt_user = $conn->prepare("SELECT referral_code FROM users WHERE id = ?");
$stmt_user->bind_param("i", $user_id);
$stmt_user->execute();
$user_result = $stmt_user->get_result();
if ($user_data = $user_result->fetch_assoc()) { $my_referral_code = $user_data['referral_code']; }
$stmt_user->close();

$referrals_sql = "SELECT r.id as referral_id, r.status, u.username FROM referrals r JOIN users u ON r.referred_id = u.id WHERE r.referrer_id = ? ORDER BY r.created_at DESC";
$referrals_stmt = $conn->prepare($referrals_sql);
$referrals_stmt->bind_param("i", $user_id);
$referrals_stmt->execute();
$referrals_result = $referrals_stmt->get_result();
$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Refer & Earn</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="/images/favicon.png">
    <style>
        .btn-share {
            background: var(--primary-color);
            color: white;
            border: none;
            padding: 12px 25px;
            border-radius: 8px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s;
            margin-top: 15px; 
            font-size: 16px;
        }
        .btn-share:hover {
            background: #7a3bad; 
            transform: translateY(-2px);
        }
        
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap');
        :root {
            --primary-color: #8e44ad;
            --background-color: #f4f7f9;
            --card-background: #ffffff;
            --text-primary: #1d2129;
            --text-secondary: #65676b;
            --success-color: #27ae60;
            --pending-color: #f39c12;
            --claimed-color: #95a5a6;
        }
        body {
            font-family: 'Poppins', sans-serif;
            background: var(--background-color);
            margin: 0;
            padding: 20px;
        }
        .container { max-width: 600px; margin: auto; }
        .card { background: var(--card-background); border-radius: 16px; margin-bottom: 25px; padding: 25px; box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05); border: 1px solid #e9ecef; }
        .card h3 { margin: 0 0 15px; color: var(--text-primary); font-size: 18px; font-weight: 600; }
        .referral-code-box { background: #f8f9fa; border: 2px dashed #ced4da; border-radius: 12px; padding: 20px; text-align: center; margin-bottom: 15px; cursor: pointer; }
        .referral-code-box span { font-size: 28px; font-weight: 700; color: var(--primary-color); letter-spacing: 4px; }
        .card p { font-size: 14px; color: var(--text-secondary); line-height: 1.6; margin: 0; }
        .msg { padding: 12px; border-radius: 8px; margin-bottom: 20px; font-weight: 500; font-size: 14px; border-left: 5px solid; }
        .msg.success { background-color: #d1f7d1; color: #146c2d; border-color: #28a745; }
        .msg.error { background-color: #f8d7da; color: #721c24; border-color: #dc3545; }
        
        .referrals-table { width: 100%; border-collapse: collapse; }
        .referrals-table th, .referrals-table td { padding: 12px 15px; text-align: left; border-bottom: 1px solid #e9ecef; }
        .referrals-table th { font-size: 12px; font-weight: 600; color: var(--text-secondary); text-transform: uppercase; }
        .referrals-table td { font-size: 15px; vertical-align: middle; }
        .referrals-table tr:last-child td { border-bottom: none; }
        
        .status-badge {
            position: relative;
            padding: 8px 12px;
            border-radius: 8px;
            font-size: 13px;
            font-weight: 600;
            color: white;
            line-height: 1.2;
            text-align: center;
            display: inline-block;
        }
        
        .status-badge::after {
            content: '';
            position: absolute;
            top: 50%;
            left: -8px; 
            margin-top: -8px; 
            border-width: 8px;
            border-style: solid;
            border-color: transparent transparent transparent; 
        }
        .status-pending { background-color: var(--pending-color); }
        .status-pending::after { border-right-color: var(--pending-color); } 

        .status-eligible { background-color: var(--success-color); }
        .status-eligible::after { border-right-color: var(--success-color); }
        
        .status-claimed { background-color: var(--claimed-color); }
        .status-claimed::after { border-right-color: var(--claimed-color); }
        
        .claim-btn { background: var(--success-color); color: white; border: none; padding: 8px 15px; border-radius: 6px; font-weight: 600; cursor: pointer; transition: background-color 0.2s; }
        .claim-btn:hover { background: #219d52; }
        
        .referral-link-container {
            margin-top: 15px;
            background: #f8f9fa;
            border-radius: 12px;
            padding: 15px;
            display: none;
        }
        .referral-link {
            word-break: break-all;
            padding: 10px;
            background: white;
            border: 1px solid #ced4da;
            border-radius: 8px;
            margin-bottom: 10px;
        }
        .copy-link-btn {
            background: var(--primary-color);
            color: white;
            border: none;
            padding: 8px 15px;
            border-radius: 6px;
            font-weight: 600;
            cursor: pointer;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <h3>Your Referral Code</h3>
            <div class="referral-code-box" onclick="copyToClipboard('<?php echo htmlspecialchars($my_referral_code); ?>')" title="Click to copy">
                <span><?php echo htmlspecialchars($my_referral_code); ?></span>
            </div>
            <p>এই কোডটি আপনার বন্ধুদের সাথে শেয়ার করুন। যখন তারা সাইন আপ করে এবং কমপক্ষে ২০ টাকা ডিপোজিট করবে, তখন আপনি নীচের তালিকা থেকে ৫ টাকা পুরস্কার ক্লেইম করতে পারবেন!</p> 

            <button id="refer-now-btn" class="btn-share">Refer Now</button>
            
            <div id="referral-link-container" class="referral-link-container">
                <p>Share this link with your friends:</p>
                <div id="referral-link" class="referral-link"></div>
                <button onclick="copyLinkToClipboard()" class="copy-link-btn">Copy Link</button>
            </div>
        </div>
        
        <div class="card">
            <h3>Your Referrals</h3>
            <?php if (!empty($message)): ?>
                <div class="msg <?php echo htmlspecialchars($message_type); ?>"><?php echo htmlspecialchars($message); ?></div>
            <?php endif; ?>
            
            <table class="referrals-table">
                <thead>
                    <tr>
                        <th>User</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($referrals_result && $referrals_result->num_rows > 0): ?>
                        <?php while($ref = $referrals_result->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($ref['username']); ?></td>
                                <td>
                                    <?php if ($ref['status'] == 'claimed'): ?>
                                        <span class="status-badge status-claimed">Claimed</span>
                                    <?php elseif ($ref['status'] == 'eligible'): ?>
                                        <span class="status-badge status-eligible">Reward Ready</span>
                                    <?php else: ?>
                                        <span class="status-badge status-pending">Pending Deposit</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if ($ref['status'] == 'eligible'): ?>
                                        <form method="POST" action="refer.php" style="margin:0;">
                                            <input type="hidden" name="referral_id" value="<?php echo $ref['referral_id']; ?>">
                                            <button type="submit" name="claim_referral" class="claim-btn">Claim 5 Tk</button>
                                        </form>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="3" style="text-align:center; padding: 20px;">You haven't referred anyone yet.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
    
    <script>
        function copyToClipboard(text) {
            if (!text) return;
            navigator.clipboard.writeText(text).then(() => {
                alert('Referral code copied: ' + text);
            }, (err) => {
                alert('Failed to copy code.');
            });
        }
        
        function copyLinkToClipboard() {
            const link = document.getElementById('referral-link').innerText;
            navigator.clipboard.writeText(link).then(() => {
                alert('Referral link copied!');
            }, (err) => {
                alert('Failed to copy link.');
            });
        }

        document.addEventListener('DOMContentLoaded', function() {
            const referButton = document.getElementById('refer-now-btn');
            const referralLinkContainer = document.getElementById('referral-link-container');
            const referralLinkElement = document.getElementById('referral-link');
            
            if (referButton) {
                const referralCode = '<?php echo addslashes(htmlspecialchars($my_referral_code)); ?>';
                const websiteLink = 'https://battlekingbd.site';
                
                // Generate the referral link
                const referralLink = `${websiteLink}/register.php?ref=${encodeURIComponent(referralCode)}`;
                referralLinkElement.innerText = referralLink;
                
                const shareMessage = 
                `টুর্নামেন্ট খেলতে চান? খেলুন আর উপার্জন করুন!
HUNTER BD71, একটি ইস্পোর্টস প্ল্যাটফর্মে যোগ দিন। প্রতিদিন ম্যাচ খেলুন এবং পুরস্কার জিতুন!.\n\n\nওয়েবসাইটে গিয়ে রেজিস্ট্রেশন করুন এবং আপনার দক্ষতা প্রমাণ করুন।
ওয়েবসাইট লিংক: ${referralLink}
রেফারাল কোড: ${referralCode}  আজই শুরু করুন, উপার্জন করুন, এবং সহজে টাকা তুলুন!` ;

                referButton.addEventListener('click', () => {
                    // Show the referral link container
                    referralLinkContainer.style.display = 'block';
                    
                    if (navigator.share) {
                        navigator.share({
                            title: 'Join me on Khelo FF!',
                            text: shareMessage,
                            url: referralLink
                        }).then(() => {
                            console.log('Thanks for sharing!');
                        }).catch(console.error);
                    } else {
                        navigator.clipboard.writeText(shareMessage).then(() => {
                            alert('Referral message copied to clipboard!');
                        }, () => {
                            alert('Failed to copy message.');
                        });
                    }
                });
            }
        });
    </script>
</body>
</html>