<?php

require_once 'db_connect.php';
$error_message = '';

define('MAX_REGISTRATIONS_PER_MONTH', 10); 

function get_user_ip() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        return $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else {
        return $_SERVER['REMOTE_ADDR'];
    }
}

$user_ip = get_user_ip();

// Check if a referral code is provided in the URL
$prefilled_refer_code = '';
if (isset($_GET['ref']) && !empty($_GET['ref'])) {
    $prefilled_refer_code = htmlspecialchars(trim($_GET['ref']));
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    $stmt_rate_check = $conn->prepare("SELECT COUNT(id) as count FROM registration_logs WHERE ip_address = ? AND created_at > NOW() - INTERVAL 1 MONTH");
    $stmt_rate_check->bind_param("s", $user_ip);
    $stmt_rate_check->execute();
    $result_rate = $stmt_rate_check->get_result();
    $reg_count = $result_rate->fetch_assoc()['count'];
    $stmt_rate_check->close();

    if ($reg_count >= MAX_REGISTRATIONS_PER_MONTH) {
        $error_message = "You have reached the maximum number of registrations from this network for this month.";
    } else {
        
        $first_name = mysqli_real_escape_string($conn, $_POST['first_name']);
        $last_name = mysqli_real_escape_string($conn, $_POST['last_name']);
        $username = mysqli_real_escape_string($conn, $_POST['username']);
        $email = mysqli_real_escape_string($conn, $_POST['email']);
        $number = mysqli_real_escape_string($conn, $_POST['number']);
        $password = $_POST['password'];
        $submitted_refer_code = trim($_POST['refer_code']);

        
        if (empty($first_name) || empty($username) || empty($email) || empty($number) || empty($password)) {
            $error_message = "Please fill in all required fields.";
        } elseif (strlen($password) < 6) {
            $error_message = "Password must be at least 6 characters long.";
        } else {
            
            $referrer_id = null; 
            if (!empty($submitted_refer_code)) {
                $stmt_ref_check = $conn->prepare("SELECT id FROM users WHERE referral_code = ?");
                $stmt_ref_check->bind_param("s", $submitted_refer_code);
                $stmt_ref_check->execute();
                $result_ref = $stmt_ref_check->get_result();
                if ($result_ref->num_rows > 0) {
                    $referrer = $result_ref->fetch_assoc();
                    $referrer_id = $referrer['id'];
                } else {
                    $error_message = "The referral code you entered is invalid.";
                }
                $stmt_ref_check->close();
            }
            
            
            if (empty($error_message)) {
                $stmt_user_check = $conn->prepare("SELECT username FROM users WHERE username = ? OR email = ?");
                $stmt_user_check->bind_param("ss", $username, $email);
                $stmt_user_check->execute();
                if ($stmt_user_check->get_result()->num_rows > 0) {
                    $error_message = "A user with that username or email already exists.";
                }
                $stmt_user_check->close();

                
                if (empty($error_message)) {
                    
                    $new_user_referral_code = strtoupper(substr(preg_replace('/[^a-zA-Z]/', '', $username), 0, 4) . bin2hex(random_bytes(3)));
                    
                    $hashed_password = password_hash($password, PASSWORD_BCRYPT);
                    
                    
                    $stmt_insert = $conn->prepare("INSERT INTO users (first_name, last_name, username, email, mobile_number, password, referral_code, referred_by_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
                    $stmt_insert->bind_param("sssssssi", $first_name, $last_name, $username, $email, $number, $hashed_password, $new_user_referral_code, $referrer_id);
                    
                    if ($stmt_insert->execute()) {
                        $new_user_id = $conn->insert_id;
                        
                        
                        $stmt_log = $conn->prepare("INSERT INTO registration_logs (ip_address) VALUES (?)");
                        $stmt_log->bind_param("s", $user_ip);
                        $stmt_log->execute();
                        $stmt_log->close();
                        
                        
                        if ($referrer_id) {
                            $stmt_create_ref = $conn->prepare("INSERT INTO referrals (referrer_id, referred_id, status) VALUES (?, ?, 'pending')");
                            $stmt_create_ref->bind_param("ii", $referrer_id, $new_user_id);
                            $stmt_create_ref->execute();
                            $stmt_create_ref->close();
                        }
                        
                        // AUTO-LOGIN LOGIC
                        session_start();
                        $_SESSION['user_id'] = $new_user_id;
                        $_SESSION['username'] = $username;

                        // Redirect directly to the home page
                        header("Location: home.php");
                        exit();
                        
                    } else {
                        $error_message = "An error occurred during registration. Please try again.";
                    }
                    $stmt_insert->close();
                }
            }
        }
    }
}

if (isset($conn)) {
    $conn->close();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Create Account</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/png" href="/images/favicon.png">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap');
        :root { --primary-glow: #00f6ff; --secondary-glow: #ff00f2; }
        * { box-sizing: border-box; }
        body {
            font-family: 'Poppins', sans-serif;
            margin: 0;
            background-color: #0f0c29;
            background-image: linear-gradient(160deg, #0f0c29 0%, #302b63 50%, #24243e 100%);
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            padding: 20px;
        }
        .login-container {
            width: 100%;
            max-width: 420px;
            padding: 40px 30px;
            background: rgba(255, 255, 255, 0.05);
            backdrop-filter: blur(10px);
            border-radius: 20px;
            border: 1px solid rgba(255, 255, 255, 0.1);
            box-shadow: 0 8px 32px 0 rgba(0, 0, 0, 0.37);
            text-align: center;
            color: #fff;
        }
        .logo-header { margin-bottom: 20px; }
        .logo-img { width: 90px; height: 90px; border-radius: 50%; border: 2px solid rgba(255, 255, 255, 0.2); box-shadow: 0 0 15px rgba(0, 246, 255, 0.3); object-fit: cover; }
        .site-name { margin-top: 10px; font-size: 20px; font-weight: 500; letter-spacing: 1px; color: #fff; }
        .login-container h2 { margin-top: 0; margin-bottom: 25px; font-size: 28px; font-weight: 600; text-transform: uppercase; letter-spacing: 2px; text-shadow: 0 0 5px var(--primary-glow); }
        .input-group { position: relative; margin-bottom: 20px; }
        .input-group svg { position: absolute; left: 15px; top: 50%; transform: translateY(-50%); width: 20px; height: 20px; fill: rgba(255, 255, 255, 0.5); }
        .input-field { width: 100%; padding: 14px 15px 14px 50px; background: rgba(0, 0, 0, 0.2); border: 1px solid rgba(255, 255, 255, 0.3); border-radius: 10px; color: #fff; font-size: 16px; transition: all 0.3s ease; }
        .input-field::placeholder { color: rgba(255, 255, 255, 0.5); }
        .input-field:focus { outline: none; border-color: var(--primary-glow); box-shadow: 0 0 15px rgba(0, 246, 255, 0.5); }
        .submit-btn { width: 100%; padding: 14px; background-image: linear-gradient(90deg, var(--primary-glow), var(--secondary-glow)); border: none; border-radius: 10px; color: #fff; font-size: 18px; font-weight: 600; text-transform: uppercase; cursor: pointer; transition: all 0.3s ease; }
        .submit-btn:hover { box-shadow: 0 0 20px rgba(0, 246, 255, 0.7); transform: scale(1.02); }
        .footer-links { margin-top: 25px; font-size: 14px; }
        .footer-links a { color: var(--primary-glow); text-decoration: none; font-weight: 500; transition: color 0.2s; }
        .footer-links a:hover { color: var(--secondary-glow); text-decoration: underline; }
        .msg.error { background: rgba(231, 76, 60, 0.2); color: #f8b4b4; border: 1px solid rgba(231, 76, 60, 0.5); padding: 10px; border-radius: 8px; margin-bottom: 20px; font-size: 14px; }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="logo-header">
            <img src="images/logo.png" alt="Website Logo" class="logo-img">
            <h3 class="site-name">Battle King BD</h3>
        </div>
        <h2>Create Account</h2>
        
        <?php if (!empty($error_message)): ?>
            <div class="msg error"><?php echo htmlspecialchars($error_message); ?></div>
        <?php endif; ?>

        <form method="POST" action="register.php">
            <div class="input-group"><svg viewBox="0 0 24 24"><path d="M12,12c2.21,0,4-1.79,4-4s-1.79-4-4-4-4,1.79-4,4,1.79,4,4,4Zm0,2c-2.67,0-8,1.34-8,4v2H20v-2c0-2.66-5.33-4-8-4Z"></path></svg><input class="input-field" type="text" name="first_name" placeholder="First Name" required></div>
            <div class="input-group"><svg viewBox="0 0 24 24"><path d="M12,12c2.21,0,4-1.79,4-4s-1.79-4-4-4-4,1.79-4,4,1.79,4,4,4Zm0,2c-2.67,0-8,1.34-8,4v2H20v-2c0-2.66-5.33-4-8-4Z"></path></svg><input class="input-field" type="text" name="last_name" placeholder="Last Name"></div>
            <div class="input-group"><svg viewBox="0 0 24 24"><path d="M12,12c2.21,0,4-1.79,4-4s-1.79-4-4-4-4,1.79-4,4,1.79,4,4,4Zm0,2c-2.67,0-8,1.34-8,4v2H20v-2c0-2.66-5.33-4-8-4Z"></path></svg><input class="input-field" type="text" name="username" placeholder="Username" required></div>
            <div class="input-group"><svg viewBox="0 0 24 24"><path d="M20,4H4A2,2,0,0,0,2,6V18a2,2,0,0,0,2,2H20a2,2,0,0,0,2-2V6A2,2,0,0,0,20,4Zm0,14H4V8l8,5,8-5Z"></path></svg><input class="input-field" type="email" name="email" placeholder="Email Address" required></div>
            <div class="input-group"><svg viewBox="0 0 24 24"><path d="M6.62,10.79c1.44,2.83,3.76,5.14,6.59,6.59l2.2-2.2c.27-.27,.67-.36,1.02-.24,1.12,.37,2.33,.57,3.57,.57,.55,0,1,.45,1,1V20c0,.55-.45,1-1,1-9.39,0-17-7.61-17-17,0-.55,.45-1,1-1h3.5c.55,0,1,.45,1,1,0,1.25,.2,2.45,.57,3.57,.11,.35,.03,.74-.24,1.02l-2.2,2.2Z"></path></svg><input class="input-field" type="tel" name="number" placeholder="Mobile Number" required></div>
            <div class="input-group"><svg viewBox="0 0 24 24"><path d="M12,17c1.1,0,2-.9,2-2s-.9-2-2-2-2,.9-2,2,.9,2,2,2Zm6-9h-1V6c0-2.76-2.24-5-5-5S7,3.24,7,6v2H6c-1.1,0-2,.9-2,2v10c0,1.1,.9,2,2,2h12c1.1,0,2-.9,2-2V10c0-1.1-.9-2-2-2Zm-6,9c-1.66,0-3-1.34-3-3s1.34-3,3-3,3,1.34,3,3-1.34,3-3,3Zm3.1-9H8.9V6c0-1.71,1.39-3.1,3.1-3.1s3.1,1.39,3.1,3.1v2Z"></path></svg><input class="input-field" type="password" name="password" placeholder="Password" required></div>
            
        
            <div class="input-group">
                <svg viewBox="0 0 24 24"><path d="M16 11c1.66 0 2.99-1.34 2.99-3S17.66 5 16 5c-1.66 0-3 1.34-3 3s1.34 3 3 3zm-8 0c1.66 0 2.99-1.34 2.99-3S9.66 5 8 5C6.34 5 5 6.34 5 8s1.34 3 3 3zm0 2c-2.33 0-7 1.17-7 3.5V19h14v-2.5c0-2.33-4.67-3.5-7-3.5zm8 0c-.29 0-.62.02-.97.05 1.16.84 1.97 1.97 1.97 3.45V19h6v-2.5c0-2.33-4.67-3.5-7-3.5z"/></svg>
                <input class="input-field" type="text" name="refer_code" placeholder="Referral Code (Optional)">
            </div>

            <button class="submit-btn" type="submit">Sign Up</button>
        </form>
        <div class="footer-links">
            <p>Already have an account? <a href="login.php">Log In</a></p>


<p><a href="privacy_policy.php" target="_blank">Privacy Policy</a></p>

        </div>
    </div>
</body>
</html>