<?php



if (session_status() === PHP_SESSION_NONE) {
    session_start();
}


if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}


if (!file_exists('db_connect.php')) {
    die("CRITICAL ERROR: The file 'db_connect.php' was not found. Please check the file path.");
}
require_once 'db_connect.php';


if (!$conn) {
    die("CRITICAL ERROR: The database connection failed. Please check your credentials in db_connect.php.");
}


$user_id = $_SESSION['user_id'];
$stmt = $conn->prepare("SELECT username, is_banned FROM users WHERE id = ?");


if ($stmt === false) {
    die("DATABASE ERROR: Failed to prepare the user query. Check if the 'users' table and 'is_banned' column exist. Error: " . $conn->error);
}

$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 1) {
    
    $user = $result->fetch_assoc();
    if ($user['is_banned'] == 1) {
        session_unset();
        session_destroy();
        header("Location: banned.php");
        exit();
    }
    $_SESSION['username'] = $user['username'];
} else {
    
    session_unset();
    session_destroy();
    header("Location: login.php?reason=invalid_session");
    exit();
}

$stmt->close();


?>