<?php
include 'header.php';

// Handle form submissions for adding/editing options
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $parent_id = (int)$_POST['parent_id'];
    $button_text = $db->real_escape_string($_POST['button_text']);
    $response_text = $db->real_escape_string($_POST['response_text']);
    $callback_data = $db->real_escape_string($_POST['callback_data']);
    $state_to_set = $db->real_escape_string($_POST['state_to_set']);
    $state_to_set = empty($state_to_set) ? NULL : $state_to_set;
    $edit_id = isset($_POST['edit_id']) ? (int)$_POST['edit_id'] : 0;

    if ($edit_id > 0) {
        // Update existing option
        $stmt = $db->prepare("UPDATE bot_options SET parent_id=?, button_text=?, response_text=?, callback_data=?, state_to_set=? WHERE id=?");
        $stmt->bind_param('issssi', $parent_id, $button_text, $response_text, $callback_data, $state_to_set, $edit_id);
    } else {
        // Insert new option
        $stmt = $db->prepare("INSERT INTO bot_options (parent_id, button_text, response_text, callback_data, state_to_set) VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param('issss', $parent_id, $button_text, $response_text, $callback_data, $state_to_set);
    }
    $stmt->execute();
    $stmt->close();
    echo "<p style='color:green;'>Option saved successfully!</p>";
}

// Handle delete
if (isset($_GET['delete'])) {
    $id_to_delete = (int)$_GET['delete'];
    $db->query("DELETE FROM bot_options WHERE id = $id_to_delete");
    // Also delete children to prevent orphans
    $db->query("DELETE FROM bot_options WHERE parent_id = $id_to_delete");
    echo "<p style='color:red;'>Option and its sub-options deleted!</p>";
}

// Fetch data for the form
$edit_data = null;
if (isset($_GET['edit'])) {
    $id_to_edit = (int)$_GET['edit'];
    $result = $db->query("SELECT * FROM bot_options WHERE id = $id_to_edit");
    $edit_data = $result->fetch_assoc();
}

$all_options_result = $db->query("SELECT id, button_text FROM bot_options WHERE id != " . ($edit_data['id'] ?? 0) . " ORDER BY button_text ASC");
?>

<h1>Manage Bot Options</h1>

<div style="background: #eef; padding: 20px; border-radius: 5px;">
    <h3><?php echo $edit_data ? 'Edit Option' : 'Add New Option'; ?></h3>
    <form action="options.php" method="POST">
        <?php if($edit_data): ?>
            <input type="hidden" name="edit_id" value="<?php echo $edit_data['id']; ?>">
        <?php endif; ?>
        
        Parent Option:
        <select name="parent_id">
            <option value="0">-- None (Top Level Menu) --</option>
            <?php while($opt = $all_options_result->fetch_assoc()): ?>
                <option value="<?php echo $opt['id']; ?>" <?php if(isset($edit_data) && $edit_data['parent_id'] == $opt['id']) echo 'selected'; ?>>
                    <?php echo htmlspecialchars($opt['button_text']); ?>
                </option>
            <?php endwhile; ?>
        </select><br><br>

        Button Text (what the user sees):<br>
        <input type="text" name="button_text" value="<?php echo htmlspecialchars($edit_data['button_text'] ?? ''); ?>" required style="width:100%;"><br><br>

        Callback Data (unique, no spaces, e.g., 'my_unique_callback'):<br>
        <input type="text" name="callback_data" value="<?php echo htmlspecialchars($edit_data['callback_data'] ?? ''); ?>" required style="width:100%;"><br><br>

        Response Text (what the bot replies):<br>
        <textarea name="response_text" rows="5" style="width:100%;"><?php echo htmlspecialchars($edit_data['response_text'] ?? ''); ?></textarea><br><br>
        
        State to Set (optional, e.g., 'awaiting_email'):<br>
        <input type="text" name="state_to_set" value="<?php echo htmlspecialchars($edit_data['state_to_set'] ?? ''); ?>" style="width:100%;"><br><br>

        <button type="submit">Save Option</button>
        <?php if($edit_data): ?>
            <a href="options.php" style="margin-left: 10px;">Cancel Edit</a>
        <?php endif; ?>
    </form>
</div>

<h2>Current Menu Structure</h2>

<?php
function display_options_tree($db, $parent_id = 0, $level = 0) {
    $result = $db->query("SELECT * FROM bot_options WHERE parent_id = $parent_id ORDER BY id ASC");
    if ($result->num_rows > 0) {
        echo "<ul style='list-style-type: none; padding-left: " . ($level * 20) . "px;'>";
        while($row = $result->fetch_assoc()) {
            echo "<li>";
            echo "<strong>" . htmlspecialchars($row['button_text']) . "</strong> ";
            echo "<code>(" . htmlspecialchars($row['callback_data']) . ")</code> ";
            echo "[<a href='options.php?edit=" . $row['id'] . "'>Edit</a>] ";
            echo "[<a href='options.php?delete=" . $row['id'] . "' onclick='return confirm(\"Are you sure? This will also delete all sub-options.\");'>Delete</a>]";
            display_options_tree($db, $row['id'], $level + 1);
            echo "</li>";
        }
        echo "</ul>";
    }
}

display_options_tree($db);
?>

<?php include 'footer.php'; ?>