<?php
include 'header.php';

$result = $db->query("SELECT * FROM telegram_users ORDER BY last_interaction DESC");
?>

<h1>Manage Users</h1>
<p>Here is a list of all users who have started your bot.</p>

<table>
    <thead>
        <tr>
            <th>Chat ID</th>
            <th>First Name</th>
            <th>Username</th>
            <th>Website Email</th>
            <th>Website Username</th>
            <th>Last Interaction</th>
        </tr>
    </thead>
    <tbody>
        <?php while($row = $result->fetch_assoc()): ?>
        <tr>
            <td><?php echo htmlspecialchars($row['chat_id']); ?></td>
            <td><?php echo htmlspecialchars($row['first_name']); ?></td>
            <td><?php echo htmlspecialchars($row['username'] ? '@' . $row['username'] : 'N/A'); ?></td>
            <td><?php echo htmlspecialchars($row['website_email'] ?? 'Not set'); ?></td>
            <td><?php echo htmlspecialchars($row['website_username'] ?? 'Not set'); ?></td>
            <td><?php echo htmlspecialchars($row['last_interaction']); ?></td>
        </tr>
        <?php endwhile; ?>
    </tbody>
</table>

<?php include 'footer.php'; ?>