
<?php
session_start();
require_once '../db_connect.php';

if (isset($_SESSION['moderator_id'])) {
    header("Location: tournaments.php");
    exit();
}

$error_message = '';
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = $_POST['username'];
    $password = $_POST['password'];

    $sql = "SELECT id, password FROM moderators WHERE username = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows == 1) {
        $moderator = $result->fetch_assoc();
        if (password_verify($password, $moderator['password'])) {
            $_SESSION['moderator_id'] = $moderator['id'];
            $_SESSION['moderator_username'] = $username;
            header("Location: tournaments.php");
            exit();
        }
    }
    $error_message = "Invalid username or password.";
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Moderator Login</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
        }
        
        .login-box {
            background: white;
            padding: 40px;
            border-radius: 15px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
            width: 350px;
            text-align: center;
        }
        
        h2 {
            color: #333;
            margin-bottom: 30px;
            font-weight: 600;
        }
        
        form {
            display: flex;
            flex-direction: column;
            gap: 20px;
        }
        
        input {
            padding: 15px;
            border: 2px solid #ddd;
            border-radius: 8px;
            font-size: 16px;
            transition: border-color 0.3s ease;
        }
        
        input:focus {
            outline: none;
            border-color: #667eea;
        }
        
        button {
            padding: 15px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.2s ease;
        }
        
        button:hover {
            transform: translateY(-2px);
        }
        
        .error {
            color: #e74c3c;
            margin: 10px 0 0 0;
            font-size: 14px;
        }
        
        @media (max-width: 480px) {
            .login-box {
                width: 90%;
                padding: 30px 20px;
            }
        }
    </style>
</head>
<body>
    <div class="login-box">
        <h2>Moderator Panel Login</h2>
        <form method="POST">
            <input type="text" name="username" placeholder="Username" required>
            <input type="password" name="password" placeholder="Password" required>
            <button type="submit">Login</button>
            <?php if ($error_message): ?><p class="error"><?php echo $error_message; ?></p><?php endif; ?>
        </form>
    </div>
</body>
</html>
